/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFileManager {
    private static final String EXT_DIRS_PROPERTY_NAME = "java.ext.dirs";
    private Map<ExtensionKey, Extension> extensionFileInfo = null;
    private Vector<File> extensionFileDirs = this.buildExtensionFileDirs();

    public ExtensionFileManager() throws IOException {
        this.extensionFileInfo = this.buildExtensionFileEntries(this.extensionFileDirs);
    }

    public Map<ExtensionKey, Extension> getExtensionFileEntries() throws IOException {
        return this.extensionFileInfo;
    }

    private Vector<File> buildExtensionFileDirs() {
        Vector<File> result = new Vector<File>();
        String extDirs = System.getProperty(EXT_DIRS_PROPERTY_NAME);
        StringTokenizer stkn = new StringTokenizer(extDirs, File.pathSeparator);
        while (stkn.hasMoreTokens()) {
            String extensionDirPath = stkn.nextToken();
            result.add(new File(extensionDirPath));
        }
        return result;
    }

    private Map<ExtensionKey, Extension> buildExtensionFileEntries(Vector<File> dirs) throws IOException {
        HashMap<ExtensionKey, Extension> result = new HashMap<ExtensionKey, Extension>();
        for (int i = 0; i < dirs.size(); ++i) {
            this.addExtJarsFromDirectory(result, i, dirs.get(i));
        }
        return result;
    }

    private void addExtJarsFromDirectory(Map<ExtensionKey, Extension> map, int extensionDirNumber, File extDir) throws IOException {
        File[] extJars = extDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (extJars != null) {
            for (File file : extJars) {
                Extension entry = this.buildExtensionForJar(file, extensionDirNumber);
                if (entry == null) continue;
                map.put(entry.extensionKey, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extension buildExtensionForJar(File file, int extDirectoryNumber) throws IOException {
        Extension extension;
        block3: {
            Extension result = null;
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                ExtensionKey key = this.getDefinedExtensionKey(jarFile);
                if (key != null) {
                    result = new Extension(key, file, extDirectoryNumber);
                }
                extension = result;
                Object var8_7 = null;
                if (jarFile == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (jarFile == null) break block4;
                    jarFile.close();
                }
                throw throwable;
            }
            jarFile.close();
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Extension> findExtensionTransitiveClosure(File anchorDir, Attributes mainAttrs) throws IOException {
        HashSet<Extension> result = new HashSet<Extension>();
        Vector<File> filesToProcess = new Vector<File>();
        filesToProcess.addAll(this.getClassPathJars(anchorDir, mainAttrs));
        Set<Extension> extensionsUsedByApp = this.getReferencedExtensions(mainAttrs);
        result.addAll(extensionsUsedByApp);
        filesToProcess.addAll(this.extensionsToFiles(extensionsUsedByApp));
        for (int i = 0; i < filesToProcess.size(); ++i) {
            Object var12_11;
            File nextFile = (File)filesToProcess.get(i);
            if (!nextFile.exists()) continue;
            JarFile nextJarFile = new JarFile(nextFile);
            try {
                Attributes attrs = this.getMainAttrs(nextJarFile);
                Set<Extension> newExtensions = this.getReferencedExtensions(attrs);
                result.addAll(newExtensions);
                filesToProcess.addAll(this.extensionsToFiles(newExtensions));
                var12_11 = null;
                if (nextJarFile == null) continue;
            }
            catch (Throwable throwable) {
                var12_11 = null;
                if (nextJarFile != null) {
                    nextJarFile.close();
                }
                throw throwable;
            }
            nextJarFile.close();
            {
                continue;
            }
        }
        return result;
    }

    private Set<File> extensionsToFiles(Set<Extension> extensions) {
        HashSet<File> result = new HashSet<File>();
        for (Extension e : extensions) {
            result.add(e.file);
        }
        return result;
    }

    private Set<Extension> getReferencedExtensions(Attributes mainAttrs) throws IOException {
        HashSet<Extension> result = new HashSet<Extension>();
        Set<ExtensionKey> extensionKeys = this.getReferencedExtensionKeys(mainAttrs);
        for (ExtensionKey key : extensionKeys) {
            if (result.contains(key)) continue;
            Extension extension = this.extensionFileInfo.get(key);
            if (extension != null) {
                result.add(extension);
                continue;
            }
            throw new IOException("Jar file requires the extension " + key + " but it is not in the known extensions " + this.extensionFileInfo);
        }
        return result;
    }

    private Attributes getMainAttrs(JarFile jarFile) throws IOException {
        Attributes result = null;
        Manifest mf = jarFile.getManifest();
        if (mf != null) {
            result = mf.getMainAttributes();
        }
        return result;
    }

    private List<File> getClassPathJars(File anchorDir, Attributes mainAttrs) {
        LinkedList<File> result = new LinkedList<File>();
        String classPathList = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
        if (classPathList != null) {
            StringTokenizer stkn = new StringTokenizer(classPathList, " ");
            while (stkn.hasMoreTokens()) {
                String classPathJarPath = stkn.nextToken();
                File classPathJarFile = new File(classPathJarPath);
                if (!classPathJarFile.isAbsolute()) {
                    classPathJarFile = new File(anchorDir, classPathJarPath);
                }
                result.add(classPathJarFile);
            }
        }
        return result;
    }

    private ExtensionKey getDefinedExtensionKey(JarFile jarFile) throws IOException {
        String extName;
        ExtensionKey result = null;
        Attributes mainAttrs = this.getMainAttrs(jarFile);
        if (mainAttrs != null && (extName = mainAttrs.getValue(Attributes.Name.EXTENSION_NAME)) != null) {
            String specVersion = mainAttrs.getValue(Attributes.Name.SPECIFICATION_VERSION);
            ExtensionKey entryKey = new ExtensionKey(extName, specVersion);
            result = new ExtensionKey(extName, specVersion);
        }
        return result;
    }

    private Set<ExtensionKey> getReferencedExtensionKeys(Attributes mainAttrs) {
        String extensionList;
        HashSet<ExtensionKey> result = new HashSet<ExtensionKey>();
        if (mainAttrs != null && (extensionList = mainAttrs.getValue(Attributes.Name.EXTENSION_LIST)) != null) {
            StringTokenizer stkn = new StringTokenizer(extensionList, " ");
            while (stkn.hasMoreTokens()) {
                String token = stkn.nextToken().trim();
                String extName = mainAttrs.getValue(token + "-" + Attributes.Name.EXTENSION_NAME);
                String specVersion = mainAttrs.getValue(token + "-" + Attributes.Name.SPECIFICATION_VERSION);
                ExtensionKey key = new ExtensionKey(extName, specVersion);
                result.add(key);
            }
        }
        return result;
    }

    public class Extension {
        private ExtensionKey extensionKey;
        private File file = null;
        private int extDirectoryNumber = -1;

        public Extension(ExtensionKey extensionKey, File file, int extDirectoryNumber) {
            assert (extensionKey != null) : "extensionKey is null";
            assert (file != null) : "file is null";
            this.extensionKey = extensionKey;
            this.file = file;
            this.extDirectoryNumber = extDirectoryNumber;
        }

        public boolean equals(Object other) {
            boolean result = false;
            if (other != null) {
                if (other == this) {
                    result = true;
                } else if (other instanceof Extension) {
                    Extension otherEntry = (Extension)other;
                    result = this.extensionKey.equals(otherEntry.extensionKey) && this.file.equals(otherEntry.file) && this.extDirectoryNumber == otherEntry.extDirectoryNumber;
                }
            }
            return result;
        }

        public int hashCode() {
            int result = 17;
            result = result * 37 + this.extensionKey.hashCode();
            result = result * 37 + this.file.hashCode();
            result = result * 37 + this.extDirectoryNumber;
            return result;
        }

        public int getExtDirectoryNumber() {
            return this.extDirectoryNumber;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.extensionKey.toString() + ", file = " + this.file.getAbsolutePath() + ", in ext dir " + this.extDirectoryNumber + "(" + ((File)ExtensionFileManager.this.extensionFileDirs.get(this.extDirectoryNumber)).getAbsolutePath();
        }
    }

    public class ExtensionKey {
        private String extensionName = null;
        private String specificationVersion = null;

        public ExtensionKey(String extensionName, String specificationVersion) {
            assert (extensionName != null) : "extensionName is null";
            this.extensionName = extensionName;
            this.specificationVersion = specificationVersion != null ? specificationVersion : "";
        }

        public boolean equals(Object other) {
            boolean result = false;
            if (other != null) {
                if (other == this) {
                    result = true;
                } else if (other instanceof ExtensionKey) {
                    ExtensionKey otherEntryKey = (ExtensionKey)other;
                    result = this.extensionName.equals(otherEntryKey.extensionName) && this.specificationVersion.equals(otherEntryKey.specificationVersion);
                }
            }
            return result;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.extensionName.hashCode();
            result = 37 * result + this.specificationVersion.hashCode();
            return result;
        }

        public String toString() {
            return "Name=" + this.extensionName + ", spec version = " + this.specificationVersion;
        }
    }
}

