/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RootDeploymentDescriptor
extends Descriptor {
    protected String moduleID;
    private String specVersion;
    protected ClassLoader classLoader = null;
    protected Map<String, PersistenceUnitsDescriptor> persistenceUnitsDescriptors = new HashMap<String, PersistenceUnitsDescriptor>();

    public RootDeploymentDescriptor() {
    }

    public RootDeploymentDescriptor(String name, String description) {
        super(name, description);
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    public abstract String getModuleID();

    public abstract String getDefaultSpecVersion();

    public String getSpecVersion() {
        if (this.specVersion == null) {
            this.specVersion = this.getDefaultSpecVersion();
        }
        try {
            Double.parseDouble(this.specVersion);
        }
        catch (NumberFormatException nfe) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "invalidSpecVersion", new Object[]{this.specVersion, this.getDefaultSpecVersion()});
            this.specVersion = this.getDefaultSpecVersion();
        }
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public abstract ModuleType getModuleType();

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public abstract ClassLoader getClassLoader();

    @Override
    public void setDisplayName(String name) {
        super.setName(name);
    }

    @Override
    public String getDisplayName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        this.setModuleID(name);
    }

    @Override
    public String getName() {
        if (this.getModuleID() != null) {
            return this.getModuleID();
        }
        return this.getDisplayName();
    }

    public void setSchemaLocation(String schemaLocation) {
        this.addExtraAttribute("schema-location", schemaLocation);
    }

    public String getSchemaLocation() {
        return (String)this.getExtraAttribute("schema-location");
    }

    public abstract boolean isApplication();

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n Module Type = ").append(this.getModuleType());
        toStringBuffer.append("\n Module spec version = ").append(this.getSpecVersion());
        if (this.moduleID != null) {
            toStringBuffer.append("\n Module ID = ").append(this.moduleID);
        }
        if (this.getSchemaLocation() != null) {
            toStringBuffer.append("\n Client SchemaLocation = ").append(this.getSchemaLocation());
        }
    }

    public Collection<PersistenceUnitsDescriptor> getPersistenceUnitsDescriptors() {
        return Collections.unmodifiableCollection(this.persistenceUnitsDescriptors.values());
    }

    public PersistenceUnitsDescriptor getPersistenceUnitsDescriptor(String puRoot) {
        return this.persistenceUnitsDescriptors.get(puRoot);
    }

    public void addPersistenceUnitsDescriptor(String puRoot, PersistenceUnitsDescriptor persistenceUnitsDescriptor) {
        assert (persistenceUnitsDescriptor.getParent() == null);
        persistenceUnitsDescriptor.setParent(this);
        persistenceUnitsDescriptor.setPuRoot(puRoot);
        this.persistenceUnitsDescriptors.put(puRoot, persistenceUnitsDescriptor);
    }
}

