/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.backend.ClientJarMakerUtils;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.interfaces.ClientJarMaker;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;

class ModuleClientJarMaker
implements ClientJarMaker {
    protected Properties props;

    public ModuleClientJarMaker(Properties props) {
        this.props = props;
    }

    public void create(RootDeploymentDescriptor descriptor, AbstractArchive source, AbstractArchive target, ZipItem[] stubs, Properties props) throws IOException {
        this.create(descriptor, source, null, target, stubs, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(RootDeploymentDescriptor descriptor, AbstractArchive source, AbstractArchive source2, AbstractArchive target, ZipItem[] stubs, Properties props) throws IOException {
        ClientJarMakerUtils.populateStubs(target, stubs);
        AbstractArchive appclientSource = null;
        AbstractArchive appclientSource2 = null;
        if (!descriptor.isApplication()) {
            appclientSource = source;
            appclientSource2 = source2;
        } else {
            List<String> libraries = ClientJarMakerUtils.getLibraryEntries((Application)Application.class.cast(descriptor), source);
            for (String entryName : libraries) {
                Object var16_16;
                AbstractArchive subSource = null;
                try {
                    subSource = source.getEmbeddedArchive(entryName);
                    Enumeration subEntries = subSource.entries();
                    while (subEntries.hasMoreElements()) {
                        String subEntryName = (String)String.class.cast(subEntries.nextElement());
                        ClientJarMakerUtils.copy(subSource, target, subEntryName);
                    }
                    var16_16 = null;
                    if (subSource == null) continue;
                }
                catch (Throwable throwable) {
                    var16_16 = null;
                    if (subSource != null) {
                        source.closeEntry(subSource);
                    }
                    throw throwable;
                }
                source.closeEntry(subSource);
            }
            Iterator modules = ((Application)Application.class.cast(descriptor)).getModules();
            while (modules.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)ModuleDescriptor.class.cast(modules.next());
                if (!md.getModuleType().equals(ModuleType.CAR)) continue;
                appclientSource = source.getEmbeddedArchive(md.getArchiveUri());
                if (source2 == null) break;
                appclientSource2 = source2.getEmbeddedArchive(md.getArchiveUri());
                break;
            }
        }
        if (appclientSource != null) {
            ClientJarMakerUtils.populateModuleJar(appclientSource, appclientSource2, target);
        } else {
            ClientJarMakerUtils.copyDeploymentDescriptors(new ApplicationArchivist(), source, source2, target);
        }
        if (descriptor.isApplication()) {
            Iterator modules = ((Application)Application.class.cast(descriptor)).getModules();
            while (modules.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)ModuleDescriptor.class.cast(modules.next());
                if (!md.getModuleType().equals(ModuleType.EJB)) continue;
                AbstractArchive subSource = source.getEmbeddedArchive(md.getArchiveUri());
                Enumeration e = subSource.entries();
                while (e.hasMoreElements()) {
                    Object var18_18;
                    String entryName = (String)String.class.cast(e.nextElement());
                    if (!entryName.endsWith(".class")) continue;
                    try {
                        try {
                            ClientJarMakerUtils.copy(subSource, target, entryName);
                        }
                        catch (IOException ioe) {
                            var18_18 = null;
                            if (subSource == null) continue;
                            source.closeEntry(subSource);
                            continue;
                        }
                        var18_18 = null;
                        if (subSource == null) continue;
                    }
                    catch (Throwable throwable) {
                        var18_18 = null;
                        if (subSource != null) {
                            source.closeEntry(subSource);
                        }
                        throw throwable;
                    }
                    source.closeEntry(subSource);
                }
            }
        }
    }
}

