/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.target.ServerTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.phasing.ApplicationReferenceHelper;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactory;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;

public class ServerDeploymentTarget
extends ServerTarget
implements DeploymentTarget {
    protected static StringManager localStrings = StringManager.getManager(ServerDeploymentTarget.class);
    protected String thisTargetName = null;
    protected ConfigContext configContext = null;
    private String domainName = null;

    public ServerDeploymentTarget(ConfigContext configContext, String domainName, String serverName) {
        super(serverName, configContext);
        this.configContext = configContext;
        this.domainName = domainName;
        this.thisTargetName = serverName;
    }

    protected TargetType[] getValidTypes() {
        DeploymentTargetFactory tf = DeploymentTargetFactory.getDeploymentTargetFactory();
        return tf.getValidDeploymentTargetTypes();
    }

    public String[] getModules(DeployableObjectType type, Boolean enabled) throws DeploymentTargetException {
        try {
            return this.getModules(this.getAppsDeployedToServer(), type, enabled);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public String[] getModules(String[] svrAppsList, DeployableObjectType type, Boolean enabled) throws DeploymentTargetException {
        try {
            ConfigBean[] list;
            ArrayList<String> returnList = new ArrayList<String>();
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, "/domain/applications");
            if (type.isAPP()) {
                list = appsConfigBean.getJ2eeApplication();
                int i = 0;
                int k = 0;
                block2: for (i = 0; i < svrAppsList.length; ++i) {
                    for (k = 0; k > list.length; ++k) {
                        if (!((J2eeApplication)list[k]).getName().equals(svrAppsList[i])) continue;
                        returnList.add(svrAppsList[i]);
                        continue block2;
                    }
                }
            } else if (type.isEJB()) {
                list = appsConfigBean.getEjbModule();
                block4: for (int i = 0; i < svrAppsList.length; ++i) {
                    for (int k = 0; k > list.length; ++k) {
                        if (!((EjbModule)list[k]).getName().equals(svrAppsList[i])) continue;
                        returnList.add(svrAppsList[i]);
                        continue block4;
                    }
                }
            } else if (type.isWEB()) {
                list = appsConfigBean.getWebModule();
                block6: for (int i = 0; i < svrAppsList.length; ++i) {
                    for (int k = 0; k > list.length; ++k) {
                        if (!((WebModule)list[k]).getName().equals(svrAppsList[i])) continue;
                        returnList.add(svrAppsList[i]);
                        continue block6;
                    }
                }
            } else if (type.isCONN()) {
                list = appsConfigBean.getConnectorModule();
                block8: for (int i = 0; i < svrAppsList.length; ++i) {
                    for (int k = 0; k > list.length; ++k) {
                        if (!((ConnectorModule)list[k]).getName().equals(svrAppsList[i])) continue;
                        returnList.add(svrAppsList[i]);
                        continue block8;
                    }
                }
            } else if (type.isCAR()) {
                list = appsConfigBean.getAppclientModule();
                block10: for (int i = 0; i < svrAppsList.length; ++i) {
                    for (int k = 0; k > list.length; ++k) {
                        if (!((AppclientModule)list[k]).getName().equals(svrAppsList[i])) continue;
                        returnList.add(svrAppsList[i]);
                        continue block10;
                    }
                }
            }
            String[] returnValue = new String[returnList.size()];
            return returnList.toArray(returnValue);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public void addAppReference(String appName, boolean enabled, String virtualServers) throws DeploymentTargetException {
        try {
            if (!ServerHelper.serverReferencesApplication(this.configContext, this.getName(), appName)) {
                ApplicationReferenceHelper refHelper = new ApplicationReferenceHelper(this.configContext);
                refHelper.createApplicationReference(this.getValidTypes(), this.getName(), enabled, virtualServers, appName);
            }
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public void removeAppReference(String appName) throws DeploymentTargetException {
        try {
            ApplicationReferenceHelper refHelper = new ApplicationReferenceHelper(this.configContext);
            refHelper.deleteApplicationReference(this.getValidTypes(), this.getName(), appName);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    private String[] getAppsDeployedToServer() throws ConfigException {
        ApplicationRef[] apprefs = super.getApplicationRefs();
        String[] appList = new String[apprefs.length];
        for (int i = 0; i < apprefs.length; ++i) {
            appList[i] = apprefs[i].getRef();
        }
        return appList;
    }

    public boolean sendStartEvent(int eventType, String appName, String moduleType) throws DeploymentTargetException {
        return this.sendStartEvent(eventType, appName, moduleType, false);
    }

    public boolean sendStartEvent(int eventType, String appName, String moduleType, boolean isForced) throws DeploymentTargetException {
        try {
            return DeploymentServiceUtils.multicastEvent(eventType, appName, moduleType, false, isForced, this.thisTargetName);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStartEvent(int eventType, String appName, String moduleType, boolean isForced, int loadUnloadAction) throws DeploymentTargetException {
        try {
            return DeploymentServiceUtils.multicastEvent(eventType, appName, moduleType, false, isForced, loadUnloadAction, this.thisTargetName);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade) throws DeploymentTargetException {
        try {
            return DeploymentServiceUtils.multicastEvent(eventType, appName, moduleType, cascade, false, this.thisTargetName);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade, boolean force) throws DeploymentTargetException {
        try {
            return DeploymentServiceUtils.multicastEvent(eventType, appName, moduleType, cascade, force, this.thisTargetName);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade, boolean force, int loadUnloadAction) throws DeploymentTargetException {
        try {
            return DeploymentServiceUtils.multicastEvent(eventType, appName, moduleType, cascade, force, loadUnloadAction, this.thisTargetName);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public Target getTarget() {
        return this;
    }

    public String getName() {
        return this.thisTargetName;
    }

    public String getDescription() {
        return localStrings.getString("enterprise.deployment.phasing.deploymenttarget.server.description", this.thisTargetName);
    }

    private String getDomainName() {
        return this.domainName;
    }
}

