/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.ResourceDeployEvent;
import com.sun.enterprise.admin.event.ResourceDeployEventListener;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ResourceDeployerFactory;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResourceManager
implements ResourceDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private ServerContext serverContext_;
    private ResourceDeployerFactory factory_ = null;
    private static StringManager localStrings = StringManager.getManager("com.sun.enterprise.server");

    public ResourceManager(ServerContext sc) {
        this.serverContext_ = sc;
        this.factory_ = new ResourceDeployerFactory();
    }

    public void resourceDeployed(ResourceDeployEvent event) throws AdminEventListenerException {
        assert (event.getJ2EEComponentType() == "resource");
        try {
            try {
                Resources rbeans = this.getResources(event.getConfigContext());
                String type = event.getResourceType();
                if (type.equals("jdbc")) {
                    ResourcesUtil.getInstance().setConfigContext(event.getConfigContext());
                    ResourcesUtil.getInstance().setReinitConfigContext(false);
                }
                Object resource = this.factory_.getResource(type, event.getResourceName(), rbeans);
                if (ResourcesUtil.getInstance().isEnabled(event.getConfigContext(), (ConfigBean)resource)) {
                    this.factory_.getResourceDeployer(type).deployResource(resource);
                }
                _logger.log(Level.INFO, "core.resourcedeployed", type + ":" + event.getResourceName());
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "core.resourcedeploy_error", e);
                throw new AdminEventListenerException(e.getMessage());
            }
            Object var6_6 = null;
            ResourcesUtil.getInstance().setReinitConfigContext(true);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ResourcesUtil.getInstance().setReinitConfigContext(true);
            throw throwable;
        }
    }

    public void resourceUndeployed(ResourceDeployEvent event) throws AdminEventListenerException {
        block6: {
            assert (event.getJ2EEComponentType() == "resource");
            try {
                try {
                    Resources rbeans = this.getResources(event.getOldConfigContext());
                    String type = event.getResourceType();
                    Object resource = this.factory_.getResource(type, event.getResourceName(), rbeans);
                    ResourcesUtil.getInstance().setConfigContext(event.getConfigContext());
                    ResourcesUtil.getInstance().setReinitConfigContext(false);
                    this.factory_.getResourceDeployer(type).undeployResource(resource);
                    _logger.log(Level.INFO, "core.resourceundeployed", type + ":" + event.getResourceName());
                }
                catch (UnsupportedOperationException nse) {
                    AdminEventMulticaster.notifyFailure(event, "restart");
                    _logger.log(Level.INFO, "core.resource_undeployed_restart_needed", event.getResourceName());
                    Object var6_8 = null;
                    ResourcesUtil.getInstance().setReinitConfigContext(true);
                    break block6;
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "core.resourceundeploy_error", e);
                    throw new AdminEventListenerException(e.getMessage());
                }
                Object var6_7 = null;
                ResourcesUtil.getInstance().setReinitConfigContext(true);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                ResourcesUtil.getInstance().setReinitConfigContext(true);
                throw throwable;
            }
        }
    }

    public void resourceRedeployed(ResourceDeployEvent event) throws AdminEventListenerException {
        assert (event.getJ2EEComponentType() == "resource");
        try {
            Resources rbeans = this.getResources(event.getConfigContext());
            String type = event.getResourceType();
            Object resource = this.factory_.getResource(type, event.getResourceName(), rbeans);
            this.factory_.getResourceDeployer(type).redeployResource(resource);
            _logger.log(Level.INFO, "core.resourceredeployed", type + ":" + event.getResourceName());
        }
        catch (UnsupportedOperationException nse) {
            AdminEventMulticaster.notifyFailure(event, "restart");
            _logger.log(Level.INFO, "core.resource_redeployed_restart_needed", event.getResourceName());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "core.resourceredeploy_error", e);
            throw new AdminEventListenerException(e.getMessage());
        }
    }

    public void resourceEnabled(ResourceDeployEvent event) throws AdminEventListenerException {
        assert (event.getJ2EEComponentType() == "resource");
        try {
            Resources rbeans = this.getResources(event.getConfigContext());
            String type = event.getResourceType();
            Object resource = this.factory_.getResource(type, event.getResourceName(), rbeans);
            this.factory_.getResourceDeployer(type).enableResource(resource);
            _logger.log(Level.INFO, "core.resourceenabled", type + ":" + event.getResourceName());
        }
        catch (UnsupportedOperationException nse) {
            AdminEventMulticaster.notifyFailure(event, "restart");
            _logger.log(Level.INFO, "core.resource_enabled_restart_needed", event.getResourceName());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "core.resourceenabled_error", e);
            throw new AdminEventListenerException(e.getMessage());
        }
    }

    public void resourceDisabled(ResourceDeployEvent event) throws AdminEventListenerException {
        assert (event.getJ2EEComponentType() == "resource");
        try {
            Resources rbeans = this.getResources(event.getConfigContext());
            String type = event.getResourceType();
            Object resource = this.factory_.getResource(type, event.getResourceName(), rbeans);
            this.factory_.getResourceDeployer(type).disableResource(resource);
            _logger.log(Level.INFO, "core.resourcedisabled", type + ":" + event.getResourceName());
        }
        catch (UnsupportedOperationException nse) {
            AdminEventMulticaster.notifyFailure(event, "restart");
            _logger.log(Level.INFO, "core.resource_disabled_restart_needed", event.getResourceName());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "core.resourcedisabled_error", e);
            throw new AdminEventListenerException(e.getMessage());
        }
    }

    public void resourceReferenceAdded(ResourceDeployEvent event) throws AdminEventListenerException {
        this.resourceDeployed(event);
    }

    public void resourceReferenceRemoved(ResourceDeployEvent event) throws AdminEventListenerException {
        this.resourceUndeployed(event);
    }

    private Resources getResources(ConfigContext ctx) throws ConfigException {
        Resources rbeans = ServerBeansFactory.getDomainBean(ctx).getResources();
        if (rbeans == null) {
            String msg = localStrings.getString("resourceManager.resource_not_found");
            throw new ConfigException(msg);
        }
        return rbeans;
    }
}

