/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.pluggable;

import com.sun.enterprise.pluggable.PluggableFeatureFactoryBaseImpl;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluggableFeatureFactoryImpl
extends PluggableFeatureFactoryBaseImpl {
    private static final String DEFAULT_FEATURES_PROPERTY_CLASS = "com.sun.enterprise.server.pluggable.PEPluggableFeatureImpl";
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public PluggableFeatureFactoryImpl(Logger logger) {
        super(logger);
    }

    public static PluggableFeatureFactory getFactory() {
        String featurePropClass = System.getProperty("com.sun.appserv.pluggable.features", DEFAULT_FEATURES_PROPERTY_CLASS);
        _logger.log(Level.FINER, "featurePropClass: " + featurePropClass);
        PluggableFeatureFactoryImpl featureFactoryImpl = new PluggableFeatureFactoryImpl(_logger);
        PluggableFeatureFactory featureFactory = (PluggableFeatureFactory)featureFactoryImpl.getInstance(featurePropClass);
        if (featureFactory == null) {
            _logger.log(Level.WARNING, "j2eerunner.pluggable_feature_noinit", featurePropClass);
        }
        return featureFactory;
    }

    protected String getDefaultFeatureFactoryPropertyName() {
        return System.getProperty("com.sun.appserv.pluggable.features");
    }

    protected Object createFeatureFactory(InvocationHandler handler) {
        return Proxy.newProxyInstance(PluggableFeatureFactory.class.getClassLoader(), new Class[]{PluggableFeatureFactory.class}, handler);
    }
}

