/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.ejb.ContainerFactory;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.types.EntityManagerReference;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.util.EntityManagerFactoryWrapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.QueryWrapper;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerWrapper
implements EntityManager,
Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EntityManagerWrapper.class);
    private String unitName;
    private PersistenceContextType contextType;
    private Map emProperties;
    private transient EntityManagerFactory entityManagerFactory;
    private transient J2EETransactionManager txManager;
    private transient ContainerFactory containerFactory;
    private transient EntityManager extendedEntityManager;
    private transient EntityManager nonTxEntityManager;

    public EntityManagerWrapper(EntityManagerReference referenceDescriptor) {
        this.unitName = referenceDescriptor.getUnitName();
        this.contextType = referenceDescriptor.getPersistenceContextType();
        this.emProperties = referenceDescriptor.getProperties();
    }

    private void init() {
        this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.unitName);
        if (this.entityManagerFactory == null) {
            throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
        }
        this.txManager = Switch.getSwitch().getTransactionManager();
        this.containerFactory = Switch.getSwitch().getContainerFactory();
    }

    private void doTransactionScopedTxCheck() {
        if (this.contextType != PersistenceContextType.TRANSACTION) {
            return;
        }
        this.doTxRequiredCheck();
    }

    private void doTxRequiredCheck() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        J2EETransaction tx = null;
        try {
            tx = (J2EETransaction)this.txManager.getTransaction();
        }
        catch (Exception e) {
            throw new IllegalStateException("exception retrieving tx", e);
        }
        if (tx == null) {
            throw new TransactionRequiredException();
        }
    }

    private EntityManager _getDelegate() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        EntityManager delegate = null;
        if (this.nonTxEntityManager != null) {
            this.cleanupNonTxEntityManager();
        }
        if (this.contextType == PersistenceContextType.TRANSACTION) {
            J2EETransaction tx = null;
            try {
                tx = (J2EETransaction)this.txManager.getTransaction();
            }
            catch (Exception e) {
                throw new IllegalStateException("exception retrieving tx", e);
            }
            if (tx != null) {
                delegate = tx.getExtendedEntityManager(this.entityManagerFactory);
                if (delegate == null && (delegate = tx.getTxEntityManager(this.entityManagerFactory)) == null) {
                    delegate = this.entityManagerFactory.createEntityManager(this.emProperties);
                    tx.addTxEntityManagerMapping(this.entityManagerFactory, delegate);
                }
            } else {
                delegate = this.nonTxEntityManager = this.entityManagerFactory.createEntityManager(this.emProperties);
            }
        } else {
            if (this.extendedEntityManager == null) {
                this.extendedEntityManager = this.containerFactory.lookupExtendedEntityManager(this.entityManagerFactory);
            }
            delegate = this.extendedEntityManager;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("In EntityManagerWrapper::_getDelegate(). Logical entity manager  = " + this);
            _logger.fine("Physical entity manager = " + delegate);
        }
        return delegate;
    }

    private void cleanupNonTxEntityManager() {
        if (this.nonTxEntityManager != null) {
            this.nonTxEntityManager.close();
            this.nonTxEntityManager = null;
        }
    }

    public void persist(Object entity) {
        this.doTransactionScopedTxCheck();
        this._getDelegate().persist(entity);
    }

    public <T> T merge(T entity) {
        this.doTransactionScopedTxCheck();
        return (T)this._getDelegate().merge(entity);
    }

    public void remove(Object entity) {
        this.doTransactionScopedTxCheck();
        this._getDelegate().remove(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        try {
            returnValue = this._getDelegate().find(entityClass, primaryKey);
            Object var5_4 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw throwable;
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        try {
            returnValue = this._getDelegate().getReference(entityClass, primaryKey);
            Object var5_4 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw throwable;
        }
        return (T)returnValue;
    }

    public void flush() {
        this.doTxRequiredCheck();
        this._getDelegate().flush();
    }

    public Query createQuery(String ejbqlString) {
        Query returnValue = null;
        try {
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, ejbqlString);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        return returnValue;
    }

    public Query createNamedQuery(String name) {
        Query returnValue = null;
        try {
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNamedQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, name);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString) {
        Query returnValue = null;
        try {
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        Query returnValue = null;
        try {
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultClass);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString, resultClass);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Query returnValue = null;
        try {
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultSetMapping);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString, resultSetMapping);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        return returnValue;
    }

    public void refresh(Object entity) {
        this.doTransactionScopedTxCheck();
        this._getDelegate().refresh(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        try {
            EntityManager delegate = this._getDelegate();
            boolean bl = delegate.contains(entity);
            Object var5_4 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (this.nonTxEntityManager == null) break block3;
                this.cleanupNonTxEntityManager();
            }
            throw throwable;
        }
    }

    public void close() {
        throw new IllegalStateException();
    }

    public boolean isOpen() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTransaction getTransaction() {
        try {
            EntityTransaction entityTransaction = this._getDelegate().getTransaction();
            Object var3_2 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            return entityTransaction;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_3 = null;
                if (this.nonTxEntityManager == null) break block3;
                this.cleanupNonTxEntityManager();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        try {
            this._getDelegate().lock(entity, lockMode);
            Object var4_3 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this._getDelegate().clear();
            Object var2_1 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        try {
            EntityManager entityManager = this._getDelegate();
            Object var3_2 = null;
            if (this.nonTxEntityManager != null) {
                this.nonTxEntityManager = null;
            }
            return entityManager;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_3 = null;
                if (this.nonTxEntityManager == null) break block3;
                this.nonTxEntityManager = null;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        try {
            FlushModeType flushModeType = this._getDelegate().getFlushMode();
            Object var3_2 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            return flushModeType;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_3 = null;
                if (this.nonTxEntityManager == null) break block3;
                this.cleanupNonTxEntityManager();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        try {
            this._getDelegate().setFlushMode(flushMode);
            Object var3_2 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw throwable;
        }
    }

    public void joinTransaction() {
        this.doTxRequiredCheck();
    }
}

