/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.wss.WebServiceSecurity;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.Implementor;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.rpc.spi.runtime.Tie;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.soap.SOAPMessage;

public class ServletSystemHandlerDelegate
implements SystemHandlerDelegate {
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static final String IMPLEMENTOR = "com.sun.xml.rpc.server.http.Implementor";
    private static final String SERVER_AUTH_CONTEXT = "com.sun.enterprise.security.jauth.ServerAuthContext";
    private static StringManager localStrings = StringManager.getManager(ServletSystemHandlerDelegate.class);
    ServerAuthConfig config_;

    public ServletSystemHandlerDelegate(ServerAuthConfig config) {
        this.config_ = config;
    }

    public boolean processRequest(SOAPMessageContext messageContext) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ws.processRequest");
        }
        final SOAPMessageContext finalMC = messageContext;
        Implementor implementor = (Implementor)messageContext.getProperty(IMPLEMENTOR);
        final Tie tie = implementor.getTie();
        StreamingHandler handler = (StreamingHandler)implementor.getTie();
        SOAPMessage request = finalMC.getMessage();
        ServerAuthContext sAC = this.config_.getAuthContext(handler, request);
        boolean status = true;
        try {
            block9: {
                try {
                    if (sAC == null) break block9;
                    status = false;
                    status = WebServiceSecurity.validateRequest((javax.xml.rpc.handler.soap.SOAPMessageContext)finalMC, sAC);
                    if (!status) break block9;
                    messageContext.setProperty(SERVER_AUTH_CONTEXT, (Object)sAC);
                }
                catch (AuthException ae) {
                    _logger.log(Level.SEVERE, "ws.error_validate_request", ae);
                    throw new RuntimeException(ae);
                }
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            WebServiceSecurity.auditInvocation((javax.xml.rpc.handler.soap.SOAPMessageContext)messageContext, status);
            throw throwable;
        }
        WebServiceSecurity.auditInvocation((javax.xml.rpc.handler.soap.SOAPMessageContext)messageContext, status);
        if (status && System.getSecurityManager() != null) {
            status = false;
            try {
                Subject.doAsPrivileged(SecurityContext.getCurrent().getSubject(), new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        tie.handle(finalMC);
                        ServletSystemHandlerDelegate.this.processResponse(finalMC);
                        return null;
                    }
                }, null);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AuthException) {
                    _logger.log(Level.SEVERE, "ws.error_secure_response", cause);
                }
                RuntimeException re = null;
                re = cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
                throw re;
            }
        }
        return status;
    }

    public void processResponse(SOAPMessageContext messageContext) {
        ServerAuthContext sAC;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ws.processResponse");
        }
        if ((sAC = (ServerAuthContext)messageContext.getProperty(SERVER_AUTH_CONTEXT)) == null) {
            return;
        }
        try {
            WebServiceSecurity.secureResponse((javax.xml.rpc.handler.soap.SOAPMessageContext)messageContext, sAC);
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "ws.error_secure_response", ae);
            throw new RuntimeException(ae);
        }
    }
}

