/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import org.apache.tomcat.util.net.jsse.JSSESocketFactory;
import sun.security.provider.Sun;

public class JSSE13SocketFactory
extends JSSESocketFactory {
    void init() throws IOException {
        try {
            String algorithm;
            String protocol;
            Security.addProvider(new Sun());
            Security.addProvider((java.security.Provider)new Provider());
            String clientAuthStr = (String)this.attributes.get("clientauth");
            if (clientAuthStr != null) {
                this.clientAuth = Boolean.valueOf(clientAuthStr);
            }
            if ((protocol = (String)this.attributes.get("protocol")) == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = defaultAlgorithm;
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)algorithm);
            String keystoreType = (String)this.attributes.get("keystoreType");
            if (keystoreType == null) {
                keystoreType = defaultKeystoreType;
            }
            String keystorePass = this.getKeystorePassword();
            kmf.init(this.getKeystore(keystoreType, keystorePass), keystorePass.toCharArray());
            TrustManager[] tm = null;
            KeyStore trustStore = this.getTrustStore(keystoreType);
            if (trustStore != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)"SunX509");
                tmf.init(trustStore);
                tm = tmf.getTrustManagers();
            }
            SSLContext context = SSLContext.getInstance((String)protocol);
            context.init(kmf.getKeyManagers(), tm, new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            if (requestedCiphers != null) {
                this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        return null;
    }

    protected void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
    }
}

