/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.model.CCTopologyBadgeSet;
import java.awt.Color;
import java.awt.Image;
import javax.servlet.ServletContext;

public final class CCDefaultBadgeSet
extends CCTopologyBadgeSet {
    public static final int SMALL = 0;
    public static final int MEDIUM = 5;
    private int scaleOffset;

    public CCDefaultBadgeSet(ServletContext context) {
        this(context, 0);
    }

    public CCDefaultBadgeSet(ServletContext context, int imageScale) {
        super(context);
        this.setImageScale(imageScale);
        this.addBadge(4, CCImage.ALARM_MINOR_SMALL, Color.blue);
        this.addBadge(3, CCImage.ALARM_MAJOR_SMALL, new Color(153, 153, 0));
        this.addBadge(2, CCImage.ALARM_CRITICAL_SMALL, Color.red);
        this.addBadge(1, CCImage.ALARM_DOWN_SMALL, Color.black);
        this.addBadge(5, null, null);
        this.addBadge(9, CCImage.ALARM_MINOR_MEDIUM, Color.blue);
        this.addBadge(8, CCImage.ALARM_MAJOR_MEDIUM, new Color(153, 153, 0));
        this.addBadge(7, CCImage.ALARM_CRITICAL_MEDIUM, Color.red);
        this.addBadge(6, CCImage.ALARM_DOWN_MEDIUM, Color.black);
        this.addBadge(10, null, null);
    }

    public int getImageScale() {
        return this.scaleOffset;
    }

    public void setImageScale(int imageScale) {
        if (imageScale != 0 && imageScale != 5) {
            throw new IllegalArgumentException("imageScale must be SMALL or MEDIUM");
        }
        this.scaleOffset = imageScale;
    }

    public int getCombinedBadge(int badge1, int badge2) {
        return badge1 == 0 ? badge2 : (badge2 == 0 ? badge1 : Math.min(badge1, badge2));
    }

    public Image getImage(int icon) {
        return super.getImage(icon + this.scaleOffset);
    }
}

