/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.listeners.MetadataEntityListener;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.internal.security.PrivilegedGetDeclaredFields;
import oracle.toplink.essentials.internal.security.PrivilegedGetDeclaredMethods;
import oracle.toplink.essentials.internal.security.PrivilegedGetField;
import oracle.toplink.essentials.internal.security.PrivilegedGetMethod;
import oracle.toplink.essentials.internal.security.PrivilegedGetMethods;
import oracle.toplink.essentials.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataHelper {
    public static final String IS_PROPERTY_METHOD_PREFIX = "is";
    public static final String GET_PROPERTY_METHOD_PREFIX = "get";
    public static final String SET_PROPERTY_METHOD_PREFIX = "set";
    public static final String SET_IS_PROPERTY_METHOD_PREFIX = "setIs";
    private static final int POSITION_AFTER_IS_PREFIX = "is".length();
    private static final int POSITION_AFTER_GET_PREFIX = "get".length();
    public static final String PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";

    public static ClassDescriptor findDescriptor(Project project, Class cls) {
        for (ClassDescriptor descriptor : project.getOrderedDescriptors()) {
            if (!descriptor.getJavaClassName().equals(cls.getName())) continue;
            return descriptor;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, AnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotation(annotation);
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        if (descriptor.ignoreAnnotations()) {
            return null;
        }
        return MetadataHelper.getAnnotation(annotation, annotatedElement);
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, MetadataAccessor accessor) {
        return MetadataHelper.getAnnotation(annotation, accessor.getAnnotatedElement(), accessor.getDescriptor());
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, MetadataDescriptor descriptor) {
        return MetadataHelper.getAnnotation(annotation, descriptor.getJavaClass(), descriptor);
    }

    public static String getAttributeNameFromMethodName(String methodName) {
        String leadingChar = "";
        String restOfName = methodName;
        if (methodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_GET_PREFIX, POSITION_AFTER_GET_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_GET_PREFIX + 1);
        } else if (methodName.startsWith(IS_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_IS_PREFIX, POSITION_AFTER_IS_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_IS_PREFIX + 1);
        }
        return leadingChar.toLowerCase().concat(restOfName);
    }

    public static Method[] getCandidateCallbackMethodsForDefaultListener(MetadataEntityListener listener) {
        return MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener);
    }

    public static Method[] getCandidateCallbackMethodsForEntityClass(Class entityClass) {
        return MetadataHelper.getDeclaredMethods(entityClass);
    }

    public static Method[] getCandidateCallbackMethodsForEntityListener(MetadataEntityListener listener) {
        HashSet<Method> candidateMethods = new HashSet<Method>();
        Class listenerClass = listener.getListenerClass();
        Method[] declaredMethods = MetadataHelper.getDeclaredMethods(listenerClass);
        for (int i = 0; i < declaredMethods.length; ++i) {
            candidateMethods.add(declaredMethods[i]);
        }
        Method[] methods = MetadataHelper.getMethods(listenerClass);
        for (int i = 0; i < methods.length; ++i) {
            if (candidateMethods.contains(methods[i])) continue;
            candidateMethods.add(methods[i]);
        }
        return candidateMethods.toArray(new Method[candidateMethods.size()]);
    }

    public static Method[] getCandidateCallbackMethodsForMappedSuperclass(Class mappedSuperclass, Class entityClass) {
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        Method[] allMethods = MetadataHelper.getMethods(entityClass);
        Method[] declaredMethods = MetadataHelper.getDeclaredMethods(mappedSuperclass);
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method method = MetadataHelper.getMethodForName(allMethods, declaredMethods[i].getName());
            if (method == null) continue;
            candidateMethods.add(method);
        }
        return candidateMethods.toArray(new Method[candidateMethods.size()]);
    }

    public static Class getClassForName(String classname, ClassLoader classLoader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(classname, true, classLoader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass(classname, exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(classname, true, classLoader);
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.unableToLoadClass(classname, exception);
        }
    }

    public static int getDeclaredAnnotationsCount(AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        if (descriptor.ignoreAnnotations()) {
            return 0;
        }
        int count = 0;
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getName().startsWith(PERSISTENCE_PACKAGE_PREFIX)) continue;
            ++count;
        }
        return count;
    }

    public static Method[] getDeclaredMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredMethods(cls);
    }

    public static Class getDiscriminatorType(String discriminatorType) {
        if (discriminatorType.equals("CHAR")) {
            return Character.class;
        }
        if (discriminatorType.equals("STRING")) {
            return String.class;
        }
        if (discriminatorType.equals("INTEGER")) {
            return Integer.class;
        }
        return null;
    }

    public static Class getFieldClassification(String temporalType) {
        if (temporalType.equals("DATE")) {
            return Date.class;
        }
        if (temporalType.equals("TIME")) {
            return Time.class;
        }
        if (temporalType.equals("TIMESTAMP")) {
            return Timestamp.class;
        }
        return null;
    }

    public static Field getFieldForName(String fieldName, Class javaClass) {
        Field field;
        block5: {
            field = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        field = (Field)AccessController.doPrivileged(new PrivilegedGetField(javaClass, fieldName, false));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        return null;
                    }
                }
                field = PrivilegedAccessHelper.getField(javaClass, fieldName, false);
            }
            catch (NoSuchFieldException nsfex) {
                return null;
            }
        }
        return field;
    }

    public static Field[] getFields(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Field[])AccessController.doPrivileged(new PrivilegedGetDeclaredFields(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredFields(cls);
    }

    public static String getFullyQualifiedTableName(String tableName, String catalog, String schema) {
        if (!catalog.equals("")) {
            tableName = catalog + "." + tableName;
        }
        if (!schema.equals("")) {
            tableName = schema + "." + tableName;
        }
        return tableName;
    }

    public static String getFullyQualifiedTableName(String name, String defaultName, String catalog, String schema) {
        String tableName = name;
        if (tableName.equals("")) {
            tableName = defaultName;
        }
        return MetadataHelper.getFullyQualifiedTableName(tableName, catalog, schema);
    }

    public static Type getGenericReturnType(Method method) {
        return method.getGenericReturnType();
    }

    public static Type getGenericType(Field field) {
        return field.getGenericType();
    }

    protected static Method getMethod(String methodName, Class cls, Class[] params) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Method)AccessController.doPrivileged(new PrivilegedGetMethod(cls, methodName, params, true));
                }
                catch (PrivilegedActionException exception) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getMethod(cls, methodName, params, true);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
    }

    public static Method getMethodForName(Method[] methods, String methodName) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Method getMethodForPropertyName(String propertyName, Class cls) {
        String leadingChar = String.valueOf(propertyName.charAt(0)).toUpperCase();
        String restOfName = propertyName.substring(1);
        Method method = MetadataHelper.getMethod(GET_PROPERTY_METHOD_PREFIX.concat(leadingChar).concat(restOfName), cls, new Class[0]);
        if (method == null) {
            method = MetadataHelper.getMethod(IS_PROPERTY_METHOD_PREFIX.concat(leadingChar).concat(restOfName), cls, new Class[0]);
        }
        return method;
    }

    public static Method[] getMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethods(cls);
    }

    public static Class getRawClassFromGeneric(Type type) {
        return (Class)((ParameterizedType)type).getRawType();
    }

    public static Class getReferenceClass(Class defaultReferenceClass, Class targetEntity) {
        if (targetEntity == Void.TYPE) {
            return defaultReferenceClass;
        }
        return targetEntity;
    }

    public static Class getReturnTypeFromGeneric(Type type) {
        ParameterizedType pType = (ParameterizedType)type;
        if (Map.class.isAssignableFrom((Class)pType.getRawType())) {
            return (Class)pType.getActualTypeArguments()[1];
        }
        return (Class)pType.getActualTypeArguments()[0];
    }

    public static Method getSetMethod(Method method, Class cls) {
        String getMethodName = method.getName();
        Class[] params = new Class[]{method.getReturnType()};
        if (getMethodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            return MetadataHelper.getMethod(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(3), cls, params);
        }
        Method setMethod = MetadataHelper.getMethod(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        if (setMethod == null) {
            return MetadataHelper.getMethod(SET_IS_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        }
        return setMethod;
    }

    public static boolean havePersistenceAnnotationsDefined(AnnotatedElement[] annotatedElements) {
        for (AnnotatedElement annotatedElement : annotatedElements) {
            for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
                if (!annotation.annotationType().getName().startsWith(PERSISTENCE_PACKAGE_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotationNotPresent(Class annotation, AnnotatedElement annotatedElement) {
        return !annotatedElement.isAnnotationPresent(annotation);
    }

    public static boolean isAnnotationPresent(Class annotation, AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(annotation);
    }

    public static boolean isAnnotationPresent(Class annotation, AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        if (descriptor.ignoreAnnotations()) {
            return false;
        }
        return MetadataHelper.isAnnotationPresent(annotation, annotatedElement);
    }

    public static boolean isAnnotationPresent(Class annotation, MetadataDescriptor descriptor) {
        return MetadataHelper.isAnnotationPresent(annotation, descriptor.getJavaClass(), descriptor);
    }

    public static boolean isEmbedded(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor) {
        AnnotatedElement annotatedElement = accessibleObject.getAnnotatedElement();
        if (MetadataHelper.isAnnotationNotPresent(Embedded.class, annotatedElement) && MetadataHelper.isAnnotationNotPresent(EmbeddedId.class, annotatedElement)) {
            return MetadataHelper.isAnnotationPresent(Embeddable.class, accessibleObject.getReferenceClass());
        }
        return MetadataHelper.isAnnotationPresent(Embedded.class, annotatedElement, descriptor);
    }

    public static boolean isEmbeddedId(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor) {
        return MetadataHelper.isAnnotationPresent(EmbeddedId.class, accessibleObject.getAnnotatedElement(), descriptor);
    }

    public static boolean isGenericCollectionType(Type type) {
        return type instanceof ParameterizedType;
    }

    public static boolean isManyToMany(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor) {
        Class rawClass = accessibleObject.getRawClass();
        AnnotatedElement annotatedElement = accessibleObject.getAnnotatedElement();
        if (MetadataHelper.isAnnotationPresent(ManyToMany.class, annotatedElement, descriptor)) {
            if (MetadataHelper.isSupportedCollectionClass(rawClass)) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(rawClass, annotatedElement);
        }
        return false;
    }

    public static boolean isManyToOne(MetadataAccessibleObject annotatedAccessor, MetadataDescriptor descriptor) {
        return MetadataHelper.isAnnotationPresent(ManyToOne.class, annotatedAccessor.getAnnotatedElement(), descriptor);
    }

    public static boolean isOneToMany(MetadataAccessibleObject annotatedAccessor, MetadataLogger logger, MetadataDescriptor descriptor) {
        Class rawClass = annotatedAccessor.getRawClass();
        AnnotatedElement annotatedElement = annotatedAccessor.getAnnotatedElement();
        if (MetadataHelper.isAnnotationNotPresent(OneToMany.class, annotatedElement)) {
            if (MetadataHelper.isGenericCollectionType(annotatedAccessor.getRelationType()) && MetadataHelper.isSupportedCollectionClass(rawClass)) {
                logger.logConfigMessage("metadata_default_one_to_many_mapping", annotatedElement);
                return true;
            }
        } else if (MetadataHelper.isAnnotationPresent(OneToMany.class, annotatedElement, descriptor)) {
            if (MetadataHelper.isSupportedCollectionClass(rawClass)) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(rawClass, annotatedElement);
        }
        return false;
    }

    public static boolean isOneToOne(MetadataAccessibleObject accessibleObject, MetadataProject project, MetadataLogger logger, MetadataDescriptor descriptor) {
        Class referenceClass = accessibleObject.getReferenceClass();
        AnnotatedElement annotatedElement = accessibleObject.getAnnotatedElement();
        if (MetadataHelper.isAnnotationNotPresent(OneToOne.class, annotatedElement)) {
            if (project.containsDescriptor(referenceClass) && !MetadataHelper.isEmbedded(accessibleObject, descriptor)) {
                logger.logConfigMessage("metadata_default_one_to_one_mapping", annotatedElement);
                return true;
            }
            return false;
        }
        return MetadataHelper.isAnnotationPresent(OneToOne.class, annotatedElement, descriptor);
    }

    public static boolean isPrimitiveWrapperClass(Class cls) {
        return cls.equals(Long.class) || cls.equals(Short.class) || cls.equals(Float.class) || cls.equals(Byte.class) || cls.equals(Double.class) || cls.equals(Number.class) || cls.equals(Boolean.class) || cls.equals(Integer.class) || cls.equals(Character.class) || cls.equals(BigInteger.class) || cls.equals(BigDecimal.class);
    }

    public static boolean isSupportedCollectionClass(Class cls) {
        return cls == Collection.class || cls == Set.class || cls == List.class || cls == Map.class;
    }

    public static boolean isValidAttributeName(String attributeName, Class javaClass) {
        Field[] attributes = MetadataHelper.getFields(javaClass);
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidBlobType(Class cls) {
        return cls.equals(byte[].class) || cls.equals(Byte[].class) || cls.equals(Blob.class) || Helper.classImplementsInterface(cls, Serializable.class);
    }

    public static boolean isValidClobType(Class cls) {
        return cls.equals(char[].class) || cls.equals(String.class) || cls.equals(Character[].class) || cls.equals(Clob.class);
    }

    public static boolean isValidEnumeratedType(Class cls) {
        return cls.isEnum();
    }

    public static boolean isValidLobType(Class cls) {
        return MetadataHelper.isValidClobType(cls) || MetadataHelper.isValidBlobType(cls);
    }

    public static boolean isValidPersistenceMethodName(String methodName) {
        return methodName.startsWith(GET_PROPERTY_METHOD_PREFIX) || methodName.startsWith(IS_PROPERTY_METHOD_PREFIX);
    }

    public static boolean isValidSerializedType(Class cls) {
        if (cls.isPrimitive()) {
            return false;
        }
        if (MetadataHelper.isPrimitiveWrapperClass(cls)) {
            return false;
        }
        if (MetadataHelper.isValidLobType(cls)) {
            return false;
        }
        return !MetadataHelper.isValidTemporalType(cls);
    }

    public static boolean isValidTemporalType(Class cls) {
        return cls.equals(java.util.Date.class) || cls.equals(Calendar.class) || cls.equals(GregorianCalendar.class);
    }

    public static boolean isValidTimstampVersionLockingType(Class cls) {
        return cls.equals(Timestamp.class);
    }

    public static boolean isValidVersionLockingType(Class cls) {
        return cls.equals(Integer.TYPE) || cls.equals(Integer.class) || cls.equals(Short.TYPE) || cls.equals(Short.class) || cls.equals(Long.TYPE) || cls.equals(Long.class);
    }

    public static boolean shouldIgnoreAnnotations(Class cls, HashMap<Class, MetadataDescriptor> metadataDescriptors) {
        MetadataDescriptor descriptor = metadataDescriptors.get(cls);
        if (descriptor != null) {
            return descriptor.ignoreAnnotations();
        }
        return false;
    }
}

