/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.common.VersionExtracter;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

public class CommonInfoModel {
    public static final String DOMAINS = "domains";
    public static final String CONFIG = "config";
    private static final String CERT_FILE_NAME = "keystore.jks";
    private static final String TRUSTED_KEY_STORE = "cacerts.jks";
    private static final String LICENSE_FILE = "LICENSE.txt";
    private static final String NUMBERSTRING = "0123456789";
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
    private static Logger logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private String[] CERT_ALIASES;
    private String SOURCE_INSTALL_DIR;
    private boolean sourceInputAsDomainRoot;
    private boolean enlistDomain;
    private String TARGET_INSTALL_DIR;
    private String InstallConfig70;
    private boolean certificateConversionFlag = false;
    private List domainList = new ArrayList();
    private List domainOptionList = new ArrayList();
    private String targetDomainRoot;
    private String sourceDomainRoot = "";
    private String currentDomain;
    private String currentSourceServerInstance = "";
    private String osName;
    private String currentCluster;
    private Hashtable domainMapping;
    private Map domainNSSPwdMapping = new HashMap();
    private Map domainTargetNSSPwdMapping = new HashMap();
    private Map domainJKSPwdMapping = new HashMap();
    private Map domainJKSCAPwdMapping = new HashMap();
    private Map domainssPwdFileMapping = new HashMap();
    private Map domainTargetnssPwdFileMapping = new HashMap();
    private Map domainNameMapping = new HashMap();
    private String sourceVersionEdition;
    private String targetVersionEdition;
    private String adminUserName = null;
    private String adminPassword = null;
    private File passwordFile = null;
    private String passwordFilePath = null;
    private String masterPassword = "changeit";

    public void setTargetDomainRoot(String targetDomainsRoot) {
        if (this.targetDomainRoot != null && this.targetDomainRoot.equals(targetDomainsRoot)) {
            return;
        }
        this.targetDomainRoot = targetDomainsRoot;
        try {
            String logPath = this.targetDomainRoot + File.separator + "upgrade.log";
            logger.info(this.stringManager.getString("common.log.redirect") + logPath);
            LogService.initialize(logPath);
        }
        catch (Exception e) {
            logger.warning(e.getLocalizedMessage());
        }
    }

    public String getTargetDomainRoot() {
        return this.targetDomainRoot;
    }

    public void setSourceDomainRoot(String sourceDomainRoot) {
        this.sourceDomainRoot = sourceDomainRoot;
    }

    public String getSourceDomainRoot() {
        return this.sourceDomainRoot;
    }

    public String getSourceDomainPath() {
        return ((DomainInfo)this.getDomainMapping().get(this.currentDomain)).getDomainPath();
    }

    public String getSourceInstancePath() {
        return ((DomainInfo)this.getDomainMapping().get(this.getCurrentDomain())).getInstancePath(this.getCurrentSourceInstance());
    }

    public String getCurrentSourceInstance() {
        return this.currentSourceServerInstance;
    }

    public void setCurrentSourceInstance(String server) {
        this.currentSourceServerInstance = server;
    }

    public String getTargetConfig() {
        String config = this.getTargetDomainRoot() + File.separator + (String)this.domainNameMapping.get(this.currentDomain) + File.separator + CONFIG;
        return config;
    }

    public String getTargetJKSKeyStorePath() {
        String path = this.getTargetDomainRoot() + File.separator + (String)this.domainNameMapping.get(this.currentDomain) + File.separator + CONFIG + File.separator + CERT_FILE_NAME;
        return path;
    }

    public String getTargetTrustedJKSKeyStorePath() {
        String path = this.getTargetDomainRoot() + File.separator + (String)this.domainNameMapping.get(this.currentDomain) + File.separator + CONFIG + File.separator + TRUSTED_KEY_STORE;
        return path;
    }

    public String getSourceJKSKeyStorePath() {
        String path = this.getSourceDomainPath() + File.separator + CONFIG + File.separator + CERT_FILE_NAME;
        return path;
    }

    public String getSourceTrustedJKSKeyStorePath() {
        String path = this.getSourceDomainPath() + File.separator + CONFIG + File.separator + TRUSTED_KEY_STORE;
        return path;
    }

    public String getDestinationDomainPath() {
        return this.getDestinationDomainPath(this.currentDomain);
    }

    public String getDestinationDomainPath(String domainName) {
        String path = this.getTargetDomainRoot() + File.separator + (String)this.domainNameMapping.get(domainName);
        return path;
    }

    public void addDomainName(String domainName) {
        this.domainList.add(domainName);
    }

    public List getDomainList() {
        return this.domainList;
    }

    public void addDomainOptionName(String domainName) {
        this.domainOptionList.add(domainName);
    }

    public List getDomainOptionList() {
        return this.domainOptionList;
    }

    public String getCurrentDomain() {
        return this.currentDomain;
    }

    public void setCurrentDomain(String domainName) {
        this.currentDomain = domainName;
    }

    public boolean getCertificateConversionFlag() {
        return this.certificateConversionFlag;
    }

    public void setCertificateConversionFlag(boolean flag) {
        this.certificateConversionFlag = flag;
    }

    public String getSourceInstallDir() {
        return this.SOURCE_INSTALL_DIR;
    }

    public String getTargetInstallDir() {
        return this.TARGET_INSTALL_DIR;
    }

    public void setSourceInstallDir(String src) {
        this.SOURCE_INSTALL_DIR = src;
    }

    public void setTargetInstallDir(String tgt) {
        this.TARGET_INSTALL_DIR = tgt;
    }

    public String getCertDbPassword() {
        Map instanceNSSPwdMap = (Map)this.domainNSSPwdMapping.get(this.currentDomain);
        return (String)instanceNSSPwdMap.get(this.currentSourceServerInstance);
    }

    public void setCertDbPassword(String pwd) {
        this.setCertDbPassword(this.currentDomain, this.currentSourceServerInstance, pwd);
    }

    public void setCertDbPassword(String domain, String pwd) {
        this.setCertDbPassword(domain, this.currentSourceServerInstance, pwd);
    }

    public void setCertDbPassword(String domain, String instance, String pwd) {
        HashMap<String, String> instanceNssPwdMap = (HashMap<String, String>)this.domainNSSPwdMapping.get(domain);
        if (instanceNssPwdMap == null) {
            instanceNssPwdMap = new HashMap<String, String>();
        }
        instanceNssPwdMap.put(instance, pwd);
        this.domainNSSPwdMapping.put(domain, instanceNssPwdMap);
    }

    public String getTargetCertDbPassword() {
        return (String)this.domainTargetNSSPwdMapping.get(this.currentDomain);
    }

    public void setTargetCertDbPassword(String pwd) {
        this.domainTargetNSSPwdMapping.put(this.currentDomain, pwd);
    }

    public void setTargetCertDbPassword(String domain, String pwd) {
        this.domainTargetNSSPwdMapping.put(domain, pwd);
    }

    public String[] getCertAliases() {
        return this.CERT_ALIASES;
    }

    public String getJksKeystorePassword() {
        return (String)this.domainJKSPwdMapping.get((String)this.domainNameMapping.get(this.currentDomain));
    }

    public void setJksKeystorePassword(String pwd) {
        this.domainJKSPwdMapping.put((String)this.domainNameMapping.get(this.currentDomain), pwd);
    }

    public void setJksKeystorePassword(String domain, String pwd) {
        this.domainJKSPwdMapping.put((String)this.domainNameMapping.get(this.currentDomain), pwd);
    }

    public String getJksCAKeystorePassword() {
        return (String)this.domainJKSCAPwdMapping.get((String)this.domainNameMapping.get(this.currentDomain));
    }

    public void setJksCAKeystorePassword(String pwd) {
        this.domainJKSCAPwdMapping.put((String)this.domainNameMapping.get(this.currentDomain), pwd);
    }

    public void setJksCAKeystorePassword(String domain, String pwd) {
        this.domainJKSCAPwdMapping.put((String)this.domainNameMapping.get(this.currentDomain), pwd);
    }

    public Hashtable getDomainMapping() {
        return this.domainMapping;
    }

    public void setDomainMapping(Hashtable domainMapping) {
        this.domainMapping = domainMapping;
    }

    public String getOSName() {
        return this.osName;
    }

    public void setOSName(String osName) {
        this.osName = osName;
    }

    public String getNSSPwdFile() {
        return (String)this.domainssPwdFileMapping.get(this.currentDomain);
    }

    public void setNSSPwdFile(String pwdFile) {
        this.domainTargetnssPwdFileMapping.put(this.currentDomain, pwdFile);
    }

    public String getTargetNSSPwdFile() {
        return (String)this.domainTargetnssPwdFileMapping.get(this.currentDomain);
    }

    public void setTargetNSSPwdFile(String pwdFile) {
        this.domainTargetnssPwdFileMapping.put(this.currentDomain, pwdFile);
    }

    public void setInstallConfig70(String config) {
        this.InstallConfig70 = config;
    }

    public String getInstallConfig70() {
        return this.InstallConfig70;
    }

    public Map getTargetDomainNameMapping() {
        return this.domainNameMapping;
    }

    public static Logger getDefaultLogger() {
        if (logger == null) {
            logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
        }
        return logger;
    }

    public boolean isUpgradeJKStoJKS() {
        return this.getTargetEdition().equals("pe") && (this.getSourceVersionAndEdition().equals("as80pe") || this.getSourceVersionAndEdition().equals("as81pe"));
    }

    public boolean isUpgradeJKStoNSS() {
        return !(!this.getTargetEdition().equals("ee") && !this.getTargetEdition().equals("se") || !this.getSourceVersionAndEdition().equals("as80pe") && !this.getSourceVersionAndEdition().equals("as81pe") && !this.getSourceVersionAndEdition().equals("as90pe"));
    }

    public boolean isUpgradeNSStoNSS() {
        return !(!this.getTargetEdition().equals("ee") && !this.getTargetEdition().equals("se") || !this.getSourceVersionAndEdition().equals("as7xpe") && !this.getSourceVersionAndEdition().equals("as7xse") && !this.getSourceVersionAndEdition().equals("as7xee") && !this.getSourceVersionAndEdition().equals("as81ee"));
    }

    public boolean isUpgradeNSStoJKS() {
        return this.getTargetEdition().equals("pe") && (this.getSourceVersionAndEdition().equals("as7xpe") || this.getSourceVersionAndEdition().equals("as7xse") || this.getSourceVersionAndEdition().equals("as7xee") || this.getSourceVersionAndEdition().equals("as81ee"));
    }

    public boolean checkUpgradefrom7xeeto9xee() {
        boolean checkUpgradefrom7xeeto8xee = false;
        if (this.getSourceInstallDir() != null && this.getTargetInstallDir() != null) {
            checkUpgradefrom7xeeto8xee = this.getSourceVersionAndEdition().equals("as7xee") && this.getTargetVersionAndEdition().equals("as90ee");
        }
        return checkUpgradefrom7xeeto8xee;
    }

    public boolean checkUpgradefrom8xpeto90pe() {
        boolean checkUpgradefrom8xpeto90pe = false;
        if (this.getSourceInstallDir() != null && this.getTargetInstallDir() != null) {
            checkUpgradefrom8xpeto90pe = (this.getSourceVersionAndEdition().equals("as80pe") || this.getSourceVersionAndEdition().equals("as81pe") || this.getSourceVersionAndEdition().equals("as82pe")) && this.getTargetVersionAndEdition().equals("as90pe");
        }
        return checkUpgradefrom8xpeto90pe;
    }

    public void enlistDomainsFromSource(List domains) {
        if (domains == null) {
            this.enlistDomainsFromSource();
        }
        if (this.enlistDomain) {
            return;
        }
        this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomainsFromUserDefinedDirectories(domains));
        this.enlistDomain = true;
    }

    public void enlistDomainsFromSource() {
        if (this.getSourceInstallDir() == null) {
            return;
        }
        if (this.enlistDomain) {
            return;
        }
        if (this.getSourceVersion().equals("7x")) {
            this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlist70DomainsFromSource(this));
        } else {
            if (this.sourceIsDomain()) {
                String source = this.getSourceInstallDir();
                if (source.endsWith(File.separator)) {
                    source = source.substring(0, source.length() - File.separator.length());
                }
                String domainName = source.substring(source.lastIndexOf(File.separator) + File.separator.length(), source.length());
                String domainRoot = source.substring(0, source.lastIndexOf(domainName) - File.separator.length());
                this.setSourceDomainRoot(domainRoot);
                this.setTargetDomainRoot(domainRoot);
                this.setSourceDomainRootFlag(true);
                this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomains(this, new String[]{domainName}, domainRoot));
            } else {
                if (this.getSourceDomainRootFlag()) {
                    this.setSourceDomainRoot(this.getSourceInstallDir());
                } else {
                    this.setSourceDomainRoot(this.getSourceInstallDir() + File.separator + DOMAINS);
                }
                this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomainsFromDomainsDirectory(this, this.getSourceDomainRoot()));
            }
            this.enlistDomain = true;
        }
    }

    private boolean sourceIsDomain() {
        return UpgradeUtils.getUpgradeUtils(this).checkSourceInputAsDomain();
    }

    public boolean checkSourceInputAsDomainRoot(String source) {
        return UpgradeUtils.getUpgradeUtils(this).checkSourceInputAsDomainRoot(source, this);
    }

    public boolean isValid70Domain(String domainPath) {
        return UpgradeUtils.getUpgradeUtils(this).isValid70Domain(domainPath);
    }

    public boolean isDomain(String domainPath) {
        return UpgradeUtils.getUpgradeUtils(this).isDomain(domainPath);
    }

    public boolean getSourceDomainRootFlag() {
        return this.sourceInputAsDomainRoot;
    }

    public void setSourceDomainRootFlag(boolean fl) {
        this.sourceInputAsDomainRoot = fl;
    }

    public void printInfo() {
        CommonInfoModel.getDefaultLogger().finest("SOURCE_INSTALL_DIR==" + this.SOURCE_INSTALL_DIR);
        CommonInfoModel.getDefaultLogger().finest("SOURCE_INSTALL_DIR==" + this.TARGET_INSTALL_DIR);
        int size = this.domainList.size();
        for (int i = 0; i < size; ++i) {
            String domainName = (String)this.domainList.get(i);
            CommonInfoModel.getDefaultLogger().finest("**********" + domainName + "****************");
            CommonInfoModel.getDefaultLogger().finest("NSSPWD==" + this.domainNSSPwdMapping.get(domainName));
            CommonInfoModel.getDefaultLogger().finest("JKSPWD==" + this.domainJKSPwdMapping.get(domainName));
            CommonInfoModel.getDefaultLogger().finest("********************************************");
        }
    }

    public String getSourceServerPolicyFileName() {
        if (this.getSourceVersion().equals("7x")) {
            return this.getSourceInstancePath() + File.separator + CONFIG + File.separator + "server.policy";
        }
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + "server.policy";
    }

    public String getTargetServerPolicyFileName() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + "server.policy";
    }

    public String getSourceDefaultWebXMLFileName() {
        if (this.getSourceVersion().equals("7x") || this.getSourceVersionAndEdition().equals("as81se")) {
            return this.getSourceInstancePath() + File.separator + CONFIG + File.separator + "default-web.xml";
        }
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + "default-web.xml";
    }

    public String getTargetDefaultWebXMLFileName() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + "default-web.xml";
    }

    public String getSourceSunACCFileName() {
        if (this.getSourceVersion().equals("7x") || this.getSourceVersionAndEdition().equals("as81se")) {
            return this.getSourceInstancePath() + File.separator + CONFIG + File.separator + "sun-acc.xml";
        }
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + "sun-acc.xml";
    }

    public String getTargetSunACCFileName() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + "sun-acc.xml";
    }

    public String getSourceConfigXMLFile() {
        if (this.getSourceVersion().equals("7x") || this.getSourceVersionAndEdition().equals("as81se")) {
            return this.getSourceInstancePath() + File.separator + CONFIG + File.separator + "server.xml";
        }
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + "domain.xml";
    }

    public String getTargetConfigXMLFile() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + "domain.xml";
    }

    public String getSourceVersionAndEdition() {
        if (this.sourceVersionEdition == null) {
            if (this.getSourceInstallDir() != null) {
                this.sourceVersionEdition = new VersionExtracter(this.getSourceInstallDir(), this).getVersion();
            } else {
                return "UNKNOWN";
            }
        }
        return this.sourceVersionEdition;
    }

    public String getTargetVersionAndEdition() {
        return this.targetVersionEdition;
    }

    public void setTargetVersionAndEdition(String verEd) {
        this.targetVersionEdition = verEd.equals("AS90PE") ? "as90pe" : "as90ee";
    }

    public void clearSourceAndTargetVersions() {
        this.sourceVersionEdition = null;
    }

    public String getSourceVersion() {
        return UpgradeUtils.getUpgradeUtils(this).versionString(this.getSourceVersionAndEdition());
    }

    public String getTargetVersion() {
        return UpgradeUtils.getUpgradeUtils(this).versionString(this.getTargetVersionAndEdition());
    }

    public String getSourceEdition() {
        return UpgradeUtils.getUpgradeUtils(this).editionString(this.getSourceVersionAndEdition());
    }

    public String getTargetEdition() {
        return UpgradeUtils.getUpgradeUtils(this).editionString(this.getTargetVersionAndEdition());
    }

    public boolean isUpgradeSupported() {
        if (this.getSourceVersionAndEdition().equals(this.getTargetVersionAndEdition())) {
            logger.info(this.stringManager.getString("sameVersionUpgradeNotRequired"));
            return false;
        }
        return ((HashSet)UpgradeConstants.supportMap.get(this.getSourceVersionAndEdition())).contains(this.getTargetVersionAndEdition());
    }

    public boolean isUpgradeSupported(String src, String targ) {
        if (src.equals(targ)) {
            return false;
        }
        return ((HashSet)UpgradeConstants.supportMap.get(src)).contains(targ);
    }

    public boolean extractVersionDetails() {
        this.sourceVersionEdition = new VersionExtracter(this.getSourceInstallDir(), this).getVersion();
        return this.sourceVersionEdition != null && this.targetVersionEdition != null;
    }

    public String getCurrentCluster() {
        return this.currentCluster;
    }

    public void setCurrentCluster(String clu) {
        this.currentCluster = clu;
    }

    public String findLatestDomainDir(String domainRoot) {
        return UpgradeUtils.getUpgradeUtils(this).findLatestDomainDir(domainRoot, this.currentDomain);
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getPasswordFile() {
        if (this.passwordFilePath == null) {
            try {
                this.passwordFile = File.createTempFile("ugpw", null);
                FileWriter writer = new FileWriter(this.passwordFile);
                writer.write("AS_ADMIN_PASSWORD=" + this.getAdminPassword() + "\n");
                writer.write("AS_ADMIN_ADMINPASSWORD=" + this.getAdminPassword() + "\n");
                writer.write("AS_ADMIN_MASTERPASSWORD=" + this.getMasterPassword() + "\n");
                writer.close();
                this.passwordFilePath = this.passwordFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                logger.severe(this.stringManager.getString("command.generalException") + " " + ioe.getMessage());
            }
        }
        return this.passwordFilePath;
    }

    public void setPasswordsFromFile(String path) {
        try {
            File userPasswordFile = new File(path);
            BufferedReader reader = new BufferedReader(new FileReader(userPasswordFile));
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.startsWith("AS_ADMIN_PASSWORD=")) {
                    this.setAdminPassword(line.substring(line.indexOf("=") + 1));
                    continue;
                }
                if (line.startsWith("AS_ADMIN_ADMINPASSWORD=")) {
                    this.setAdminPassword(line.substring(line.indexOf("=") + 1));
                    continue;
                }
                if (!line.startsWith("AS_ADMIN_MASTERPASSWORD=")) continue;
                this.setMasterPassword(line.substring(line.indexOf("=") + 1));
            }
            reader.close();
        }
        catch (Exception e) {
            logger.severe(this.stringManager.getString("command.generalException") + " " + e.getMessage());
        }
    }

    public void setMasterPassword(String pw) {
        this.masterPassword = pw;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    public void deletePasswordFile() {
        if (this.passwordFile != null) {
            this.passwordFile.delete();
        }
    }

    public String getSourceInitConfFileName() {
        if (this.getSourceVersion().equals("7x")) {
            return this.getSourceInstancePath() + File.separator + CONFIG + File.separator + "init.conf";
        }
        return null;
    }

    public void recover() {
        UpgradeUtils.getUpgradeUtils(this).recover();
    }

    public boolean processClinstnceConfFiles(Vector files) {
        return ClustersInfoManager.getClusterInfoManager().processClinstanceConfFiles(files);
    }
}

