/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;

public class DeploymentHelper {
    private static final String DEFAULT_NAME = "default";
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", DeploymentHelper.class.getClassLoader());
    private static Logger logger = LogHelperPersistenceManager.getLogger();

    public static String getDDLNamePrefix(Object info) {
        StringBuffer rc = new StringBuffer();
        if (info instanceof BundleDescriptor) {
            BundleDescriptor bundle = (BundleDescriptor)info;
            rc.append(bundle.getApplication().getRegistrationName());
            Application application = bundle.getApplication();
            if (!application.isVirtual()) {
                String modulePath = bundle.getModuleDescriptor().getArchiveUri();
                int l = modulePath.length();
                rc.append('_').append(modulePath.substring(0, l - 4));
            }
        }
        return rc.length() == 0 ? DEFAULT_NAME : rc.toString();
    }

    public static boolean isJavaToDatabase(EjbBundleDescriptor bundle) {
        Properties userPolicy = bundle.getCMPResourceReference().getSchemaGeneratorProperties();
        return DeploymentHelper.isJavaToDatabase(userPolicy);
    }

    public static boolean isJavaToDatabase(Properties prop) {
        String value;
        if (prop != null && !StringHelper.isEmpty(value = prop.getProperty("java-to-database"))) {
            if (logger.isLoggable(500)) {
                logger.fine("java-to-database property is set.");
            }
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static Connection getConnection(String name) throws SQLException {
        if (logger.isLoggable(500)) {
            logger.fine("ejb.DeploymentHelper.getconnection", name);
        }
        return ConnectorRuntime.getRuntime().getConnection(name);
    }

    private static void handleUnexpectedInstance(String name, Object value) {
        JDOFatalUserException e = new JDOFatalUserException(I18NHelper.getMessage(messages, "ejb.jndi.unexpectedinstance", name, value.getClass().getName()));
        logger.severe(((Throwable)e).toString());
        throw e;
    }
}

