/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.layout.descriptor;

import com.sun.enterprise.tools.jsfext.component.ComponentUtil;
import com.sun.enterprise.tools.jsfext.event.AfterEncodeEvent;
import com.sun.enterprise.tools.jsfext.event.BeforeEncodeEvent;
import com.sun.enterprise.tools.jsfext.event.EncodeEvent;
import com.sun.enterprise.tools.jsfext.event.handlers.Handler;
import com.sun.enterprise.tools.jsfext.event.handlers.HandlerContext;
import com.sun.enterprise.tools.jsfext.event.handlers.HandlerContextImpl;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutDefinition;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutElement;
import com.sun.web.ui.util.RenderingUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public abstract class LayoutElementBase
implements LayoutElement {
    private List _layoutElements = new ArrayList();
    private LayoutElement _parent = null;
    private Map _handlersByType = new HashMap();
    private String _id = null;
    public static final String AFTER_ENCODE = "afterEncode";
    public static final String BEFORE_ENCODE = "beforeEncode";
    public static final String ENCODE = "encode";

    protected LayoutElementBase(LayoutElement parent, String id) {
        this.setParent(parent);
        this._id = id;
    }

    public void addChildLayoutElement(LayoutElement element) {
        this._layoutElements.add(element);
    }

    public List getChildLayoutElements() {
        return this._layoutElements;
    }

    public LayoutDefinition getLayoutDefinition() {
        LayoutElement cur = this;
        while (cur.getParent() != null) {
            cur = cur.getParent();
        }
        return (LayoutDefinition)cur;
    }

    public LayoutElement getParent() {
        return this._parent;
    }

    protected void setParent(LayoutElement parent) {
        this._parent = parent;
    }

    private String getId() {
        if (this._id == null) {
            return "";
        }
        return this._id;
    }

    public String getUnevaluatedId() {
        return this._id;
    }

    public String getId(FacesContext context, UIComponent parent) {
        Object value = this.resolveValue(context, parent, this.getId());
        return value == null ? "" : value.toString();
    }

    public Object resolveValue(FacesContext context, UIComponent parent, String value) {
        return ComponentUtil.resolveValue(context, this, parent, value);
    }

    protected abstract boolean encodeThis(FacesContext var1, UIComponent var2) throws IOException;

    public void encode(FacesContext context, UIComponent component) throws IOException {
        Object result = this.dispatchHandlers(context, BEFORE_ENCODE, new BeforeEncodeEvent(component));
        boolean renderChildren = this.encodeThis(context, component);
        if (renderChildren) {
            result = this.dispatchHandlers(context, ENCODE, new EncodeEvent(component));
            LayoutElement childElt2 = null;
            for (LayoutElement childElt2 : this.getChildLayoutElements()) {
                childElt2.encode(context, component);
            }
        }
        result = this.dispatchHandlers(context, AFTER_ENCODE, new AfterEncodeEvent(component));
    }

    public Object dispatchHandlers(FacesContext context, String eventType, EventObject event) {
        List handlers;
        Object eventObj = event.getSource();
        if (!(eventObj instanceof UIComponent)) {
            eventObj = null;
        }
        if ((handlers = this.getHandlers(eventType, (UIComponent)eventObj)) == null) {
            return null;
        }
        HandlerContext handlerContext = this.createHandlerContext(context, event, eventType);
        return this.dispatchHandlers(handlerContext, handlers);
    }

    public Object dispatchHandlers(HandlerContext handlerCtx, List handlers) {
        Object retVal = null;
        Object result = null;
        Handler handler = null;
        Iterator it = handlers.iterator();
        while (it.hasNext()) {
            try {
                handler = (Handler)it.next();
                handlerCtx.setHandler(handler);
                retVal = handler.invoke(handlerCtx);
                if (retVal == null) continue;
                result = retVal;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getClass().getName() + " while attempting to " + "process a '" + handlerCtx.getEventType() + "' event for '" + this.getId() + "'.", ex);
            }
        }
        return result;
    }

    protected HandlerContext createHandlerContext(FacesContext context, EventObject event, String eventType) {
        return new HandlerContextImpl(context, this, event, eventType);
    }

    public List getHandlers(String type) {
        return (List)this._handlersByType.get(type);
    }

    public Map getHandlersByTypeMap() {
        return this._handlersByType;
    }

    public void setHandlersByTypeMap(Map map) {
        if (map != null) {
            this._handlersByType = map;
        }
    }

    public List getHandlers(String type, UIComponent comp) {
        List handlers = this.getHandlers(type);
        return handlers;
    }

    public void setHandlers(String type, List handlers) {
        this._handlersByType.put(type, handlers);
    }

    public static void encodeChild(FacesContext context, UIComponent component) throws IOException {
        RenderingUtilities.renderComponent((UIComponent)component, (FacesContext)context);
    }
}

