/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/cpp/solaris-monitoring/AttributeMgrBase.h,v 1.3 2005/12/25 03:45:25 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:25 $
 */
 
 
#include <string>
#include <vector>

#include "AttributeInfo.h"

/*
	Override the methods in this class.
 */
class AttributeMgrBase
{
public:
	typedef std::vector<AttributeInfo>		AttributeInfoList;
	typedef std::vector<std::string>		ScopeNameList;
	
	
	AttributeMgrBase()
	{
	}
	
		virtual
	~AttributeMgrBase()
	{
	}


	/*
		Return array of scope names. The scope name is used as an identifying string corresponding
		to the particular group of Solaris attributes it covers.
		The scope name must *not* contain the following characters: SPACE ',' '='

		The scope name will be user-visible within the JMX ObjectName as the 'scope' property eg:
		
		domain:type=solaris-monitoring,scope=<name>
		
	 */
	virtual ScopeNameList	getScopeNames( );
	
	
	/*
		Return list of AttributeInfo for all attributes available from one of the
		names returned by getMBeanNames()
	 */
	virtual AttributeInfoList	getAttributeInfo( const char *scopeName );
	
	
	/*
		Return the current value of the named attribute in the given scope.
	 */
	virtual std::string		getAttributeValue( const char *scopeName, const char *attributeName );
	
};















