/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/HelpCmd.java,v 1.3 2005/12/25 03:45:36 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:36 $
 */
 
package com.sun.cli.jmx.cmd;

import com.sun.cli.jmx.support.CLISupportMBeanProxy;
import com.sun.cli.jmx.support.InspectRequest;
import com.sun.cli.jmx.support.InspectResult;
import com.sun.cli.jmx.support.InspectResult;
 
import com.sun.cli.util.stringifier.ArrayStringifier;

public class HelpCmd extends JMXCmd
{
		public
	HelpCmd( final CmdEnv env )
	{
		super( env );
	}
	
		int
	getNumRequiredOperands()
	{
		// there may be some, but there may be none
		return( 0 );
	}
	
	
		String
	getUsage()
	{
		String	usage	= "*** Available commands ***\n\n";
		
		final CmdStrings.CmdHelp [] allHelp	= CmdStrings.getAllHelp();
		
		for( int i = 0; i < allHelp.length; ++i )
		{
			usage	= usage + allHelp[ i ].getSynopsis() + "\n\n";
		}
		
		return( usage );
	}
	
		public static String []
	getNames( )
	{
		return( new String [] { "help", "h", "--h"} );
	}
	
		private String
	stripColon( String cmd )
	{
		String	cmdString	= cmd;
		
		if ( cmdString.endsWith( ":" ) )
		{
			// indicates generic JMX method
			cmdString	= cmdString.substring( 0, cmdString.length() -1);
		}
		return( cmdString );
	}
	
		String
	getHelpUnknown( String cmdString )
	{
		cmdString	= stripColon( cmdString );
		
		String msg	= "";
		
		try
		{
			establishProxy();

			// if there is a proxy, see if any MBeans have matching operations
			final CLISupportMBeanProxy	proxy	= getProxy();
			
			if ( proxy != null && ! cmdString.equals( "*" ) )
			{
				final InspectRequest	request	= new InspectRequest();
				
				// ask for operations only
				request.includeSummary		= true;
				request.includeDescription	= false;
				request.attrs				= null;
				request.notifications		= null;
				request.constructors		= false;
				request.operations			= cmdString;
				final InspectResult []	results	=
						proxy.mbeanInspect( request, new String [] { "*" }  );
			
				String	operationsMsg	= "";
				
				for( int i = 0; i < results.length; ++i )
				{
					final InspectResult	result	= results[ i ];
					
					if ( result.operationsInfo.length != 0 )
					{
						operationsMsg	= operationsMsg + result.objectInstance.getObjectName() + "\n";
						operationsMsg	= operationsMsg + ArrayStringifier.DEFAULT.stringify( result.operationsInfo, "\n");
						operationsMsg	= operationsMsg + "\n\n";
					}
				}
				
				if ( operationsMsg.length() != 0 )
				{
					msg	= msg + operationsMsg;
				}
			}
		}
		catch( Exception e )
		{
			// squelch
		}
		
		return( msg );
	}
	
		void
	executeInternal()
		throws Exception
	{
		final String [] operands	= getOperands();
		
		if ( operands.length == 0 )
		{
			printUsage();
		}
		else
		{
			for ( int i = 0; i < operands.length; ++i )
			{
				final String	cmd	= operands[ i ];
				
				CmdStrings.CmdHelp	help	= CmdStrings.getHelp( cmd );
				
				if ( help == null )
				{
					final Class cmdClass	= getCmdFactory().getClass( cmd );
					
					if ( cmdClass != null )
					{
						final String [] aka	= getCmdNames( cmdClass );
						if ( aka != null && aka.length != 0)
						{
							help	= CmdStrings.getHelp( aka[ 0 ] );
						}
					}
				}
				
				String	msg	= null;
				
				if ( help != null )
				{
					msg	= help.toString();
					
					final Class cmdClass	= getCmdFactory().getClass( cmd );
					if ( cmdClass != null )
					{
						msg	= msg + "\n" + getAlsoKnownAs( cmdClass );
					}
				}
				else
				{
					println( "Searching for MBeans with operation \"" + stripColon( cmd ) + "\"" );
					msg	= getHelpUnknown( cmd );
					if ( msg == null || msg.length() == 0 )
					{
						println( "No matching operations found" );
					}
				}
				
				println( msg );
			}
		}
	}
}
