/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/JMXAdminFileNames.java,v 1.3 2005/12/25 03:45:37 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:37 $
 */
package com.sun.cli.jmx.cmd;

import java.io.File;

public final class JMXAdminFileNames
{
		private
	JMXAdminFileNames()
	{
	}

	public final static String FOLDER_NAME		= "jmxadmin";
	public final static  String	PROPS_FILE		= "jmxadmin-env.props";
	public final static String	ALIASES_FILE	= "jmxadmin-aliases.props";
	
	
		public static String
	getHomeDir()
	{
		final String name = System.getProperty( "user.home" ) + "/";
		return( name );
	}
	
		public static File
	getPropsFile()
	{
		final String name	= getHomeDir() + PROPS_FILE;
		
		return( new File( name ) );
	}
	
		public static File
	getAliasesFile()
	{
		final String name	= getHomeDir() + ALIASES_FILE;
		
		return( new File( name ) );
	}
}

