/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/ListenCmd.java,v 1.3 2005/12/25 03:45:38 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:38 $
 */
 
package com.sun.cli.jmx.cmd;

import java.io.File;
import java.io.PrintStream;

import javax.management.ObjectName;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServerNotification;
import javax.management.NotificationListener;
import javax.management.monitor.MonitorNotification;
import javax.management.Notification;

import com.sun.cli.util.stringifier.*;



class MyNotificationListener implements NotificationListener
{
	MyCmdOutput 		mOutput;
	boolean				mPaused	= false;
	SmartStringifier	mStringifier;
	
		static SmartStringifier
	setupStringifier()
	{
		// set up our options the way we want them
		final NotificationStringifier.Options options	=
					new NotificationStringifier.Options();
		options.mDelim	= "\n";
		
		// create a new registry and put our versions in place
		final StringifierRegistry	myRegistry	=
			new StringifierRegistry( StringifierRegistry.DEFAULT );
		
		// register our stringifiers with desired options
		myRegistry.add( Notification.class,
			new NotificationStringifier( options ));
		
		myRegistry.add( AttributeChangeNotification.class,
			new AttributeChangeNotificationStringifier( options ) );
		
		myRegistry.add( MBeanServerNotification.class,
			new MBeanServerNotificationStringifier( options ) );
		
		myRegistry.add( MonitorNotification.class,
			new MonitorNotificationStringifier( options ) );
			
		final SmartStringifier s	= new SmartStringifier( myRegistry, ",", true);
		
		return( s );
	}
	
		public
	MyNotificationListener( MyCmdOutput output )
	{
		mOutput			= output;
		mStringifier	= setupStringifier();
	}
	
		public void
	setOutput( MyCmdOutput output )
	{
		assert( mOutput != null );
		mOutput.close();
		mOutput	= output;
	}
	
		public void
	handleNotification( Notification notif, Object o)
	{
		if ( ! mPaused )
		{
			final String	msg	=  mStringifier.stringify( notif ) + "\n";
			
			mOutput.println( msg );
		}
	}
	
		public void
	togglePaused( )
	{
		mPaused	= ! mPaused;
	}
	
		public void
	setPaused( boolean paused )
	{
		mPaused	= paused;
	}

};

class MyCmdOutput implements CmdOutput
{
	private final CmdOutput		mFileOutput;
	private final CmdOutput		mStdOutput;
	
	MyCmdOutput()
	{
		mFileOutput	= new CmdOutputNull();
		mStdOutput	= new CmdOutputImpl( System.out, System.err );
	}
	
	MyCmdOutput( File theFile, boolean echoToStdOut )
		throws java.io.IOException
	{
		mFileOutput	= new CmdOutputToFile( theFile );
		
		if ( echoToStdOut )
		{
			mStdOutput	= new CmdOutputImpl( System.out, System.err);
		}
		else
		{
			mStdOutput	= new CmdOutputNull();
		}
	}
		public void
	print( Object o )
	{
		mFileOutput.print( o );
		mStdOutput.print( o );
	}
	
		public void
	println( Object o )
	{
		print( o + "\n" );
	}
	
		public void
	printError( Object o )
	{
		println( o );
	}
	
		public void
	printDebug( Object o )
	{
		println( o );
	}
	
		public void
	close()
	{
		if ( mFileOutput instanceof CmdOutputToFile )
		{
			((CmdOutputToFile)mFileOutput).close();
		}
	}
}
	
public class ListenCmd extends JMXCmd
{
		public
	ListenCmd( final CmdEnv env )
	{
		super( env );
	}
	
	private final static String	STOP_OPTION		= "stop";
	private final static String	PAUSE_OPTION	= "pause";
	private final static String	FILE_OPTION		= "file";
	private final static String	STDOUT_OPTION	= "stdout";
	
	static private final String	OPTIONS_INFO	=
		STOP_OPTION +
		" " + PAUSE_OPTION +
		" " + FILE_OPTION + ",1" +
		" " + STDOUT_OPTION;
	
		ArgHelper.OptionsInfo
	getOptionInfo()
		throws ArgHelper.IllegalOptionException
	{
		return( new ArgHelperOptionsInfo( OPTIONS_INFO ) );
	}
	
		int
	getNumRequiredOperands()
	{
		return( 0 );
	}
	
		public String
	getUsage()
	{
		return( CmdStrings.LISTEN_HELP.toString() );
	}
	
		public static String []
	getNames( )
	{
		return( new String [] { "listen" } );
	}
	
	
	private final static MyNotificationListener	sNotificationListener	=
			new MyNotificationListener( new MyCmdOutput( ) );
	
		void
	startListening( final String []	targets, String filename)
		throws Exception
	{
		if ( filename != null )
		{
			boolean	toStdOut	= getBoolean( STDOUT_OPTION, null ) != null;
			
			final File	theFile	= new File( filename );
			
			sNotificationListener.setOutput( new MyCmdOutput( theFile, toStdOut ) );
		}
		
		getProxy().mbeanListen( true, targets, sNotificationListener, null, null );
		sNotificationListener.setPaused( false );
	}
	
		void
	stopListening( final String []	targets )
		throws Exception
	{
		getProxy().mbeanListen( false, targets, sNotificationListener, null, null );
	}
	
		void
	pauseListening()
	{
		sNotificationListener.togglePaused( );
	}
	
	
		void
	executeInternal()
		throws Exception
	{
		final String []	targets	= getTargets();
		
		final String	fileOption	= getString( FILE_OPTION, null );
		final Boolean	stopOption	= getBoolean( STOP_OPTION, null );
		final Boolean	pauseOption	= getBoolean( PAUSE_OPTION, null );
		
		establishProxy();
		if ( stopOption != null )
		{
			if ( fileOption != null )
			{
				throw new IllegalArgumentException( STOP_OPTION + " cannot specify a file"  );
			}
			if ( ! stopOption.booleanValue() )
			{
				throw new IllegalArgumentException( STOP_OPTION + " cannot be false"  );
			}
			stopListening( targets );
		}
		else if ( pauseOption != null )
		{
			if ( fileOption != null )
			{
				throw new IllegalArgumentException( PAUSE_OPTION + " cannot specify a file"  );
			}
			if ( ! stopOption.booleanValue() )
			{
				throw new IllegalArgumentException( PAUSE_OPTION + " cannot be false"  );
			}
			
			pauseListening();
		}
		else if ( getBoolean( STOP_OPTION, null ) == null  &&
			getBoolean( PAUSE_OPTION, null ) == null )
		{
			// if it's not a pause or stop, then it's a start
			startListening( targets, fileOption );
		}
		else
		{
			throw new ArgHelper.IllegalOptionException( "illegal options" );
		}
	}
}
