/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/InvokeResultIteratorStringifier.java,v 1.3 2005/12/25 03:45:48 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:48 $
 */
 

package com.sun.cli.jmx.support;

import com.sun.cli.util.stringifier.*;

public class InvokeResultIteratorStringifier extends IteratorStringifierBase
{
		public 
	InvokeResultIteratorStringifier( String delim )
	{
		super(  delim, InvokeResultStringifier.DEFAULT );
	}
	
	/*
		Subclass may choose to override this.
	 */
		public void
	stringifyElement(
		Object			elem,
		String			delim,
		StringBuffer	buf)
	{
		final InvokeResult	r	= (InvokeResult)elem;
		
		final InvokeResult.ResultType	result	= r.getResultType();
		
		// don't output "not found" results; only those that
		// were invoked and succeeded or failed
		if ( result == InvokeResult.SUCCESS ||
			result == InvokeResult.FAILURE )
		{
			buf.append( mElementStringifier.stringify( elem ) );
			buf.append( delim );
		}
	}
}