/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/ResultsForGetSetStringifier.java,v 1.3 2005/12/25 03:45:50 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:50 $
 */
 

package com.sun.cli.jmx.support;

import javax.management.Attribute;

import com.sun.cli.jmx.support.ResultsForGetSet;

import com.sun.cli.util.stringifier.*;


public class ResultsForGetSetStringifier implements Stringifier
{
	final Options	mOptions;
	
	public static final class Options
	{
		final static Options	DEFAULT	= new Options();
		
		final boolean	mIncludeObjectName;
		final int		mDisplayType;
		
		public final static int	DISPLAY_TERSE	= 0;
		public final static int	DISPLAY_PRETTY	= 1;
		
		
			public
		Options( boolean includeObjectName, int displayType )
		{
			mIncludeObjectName	= includeObjectName;
			mDisplayType		= DISPLAY_PRETTY;
		} 
		
			public
		Options(  )
		{
			this( true, DISPLAY_PRETTY );
		} 
	};
	
		public 
	ResultsForGetSetStringifier(  )
	{
		mOptions	= Options.DEFAULT;
	}
		public 
	ResultsForGetSetStringifier( Options options )
	{
		mOptions	= options;
	}

		public String
	stringify( Object o )
	{
		final ResultsForGetSet	result	= (ResultsForGetSet)o;
		
		String	str	= "";
		
		if ( mOptions.mIncludeObjectName )
		{
			str	= "---" + result.getName().toString() + "---";
		}
		final boolean	pretty	= mOptions.mDisplayType == Options.DISPLAY_PRETTY;
		
		final Stringifier attrS	= new AttributeStringifier();
		final Object []	attrList	= result.getAttributes().toArray();
		
		if ( pretty )
		{
			str	= str + "\n";
		}

		if ( attrList.length == 0 )
		{
			str	= str + "<no attributes found>";
		}
		else
		{
			String	delim;
			
			if ( pretty )
				delim	= "\n";
			else
				delim	= ",";
				
			str	= str + ArrayStringifier.stringify( attrList , delim, attrS );
		}
		
		return( str );
	}
}
