/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/util/stringifier/MBeanInfoStringifier.java,v 1.3 2005/12/25 03:46:05 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:46:05 $
 */
 
package com.sun.cli.util.stringifier;

import java.lang.reflect.Array;
import javax.management.*;

public class MBeanInfoStringifier extends MBeanFeatureInfoStringifier implements Stringifier
{
	public static MBeanInfoStringifier	DEFAULT	= new MBeanInfoStringifier(  );
	
		public
	MBeanInfoStringifier(  )
	{
		super(  );
	}
	
		public
	MBeanInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		super( options );
	}
	
		private String
	stringifyArray( Object [] a, Stringifier stringifier)
	{
		String	temp	= "";
		
		if ( Array.getLength( a ) != 0 )
		{
			temp	= "\n" + ArrayStringifier.stringify( a, "\n", stringifier);
		}
		return( temp );
	}
	
	// subclass may override
		MBeanAttributeInfoStringifier
	getMBeanAttributeInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new MBeanAttributeInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanOperationInfoStringifier
	getMBeanOperationInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new MBeanOperationInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanConstructorInfoStringifier
	getMBeanConstructorInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new MBeanConstructorInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanNotificationInfoStringifier
	getMBeanNotificationInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new MBeanNotificationInfoStringifier(options) );
	}
	
		public String
	stringify( Object o)
	{
		String			result	= "";
		final MBeanInfo	info	= (MBeanInfo)o;
		
		final MBeanOperationInfo []		operations		= info.getOperations();
		final MBeanAttributeInfo []		attributes		= info.getAttributes();
		final MBeanConstructorInfo []	constructors	= info.getConstructors();
		final MBeanNotificationInfo []	notifications	= info.getNotifications();
		
		result	= "Summary: " +
					operations.length + " operations, " +
					attributes.length + " attributes, " +
					constructors.length + " constructors, " +
					notifications.length + " notifications" ;
		
		final MBeanFeatureInfoStringifierOptions options	=
				new MBeanFeatureInfoStringifierOptions( true, "," );
		
		// Do formal terms like "Attributes" need to be I18n?
		// Probabably not as they are part of a specification.
		if ( attributes != null )
		{
			result	= result + "\n\n- Attributes -" +
						stringifyArray( attributes, getMBeanAttributeInfoStringifier( options ) );
		}
		
		if ( operations != null )
		{
			result	= result + "\n\n- Operations -" +
						stringifyArray( operations, getMBeanOperationInfoStringifier(options) );
		}
		
		if ( constructors != null )
		{
			result	= result + "\n\n- Constructors -" +
						stringifyArray( constructors, getMBeanConstructorInfoStringifier(options) );
		}
		
		if ( notifications!= null )
		{
			result	= result + "\n\n- Notifications -" + 
						stringifyArray( notifications, getMBeanNotificationInfoStringifier(options) );
		}
		
		return( result );
			
	}
}





