/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/enterprise/jmx/kstat/kstat.java,v 1.3 2005/12/25 03:46:09 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:46:09 $
 */
package com.sun.enterprise.jmx.kstat;

import java.util.HashMap;
import java.util.Set;

import com.sun.cli.util.ClassUtil;
import com.sun.cli.util.stringifier.SmartStringifier;

public final class kstat
{
	final String				mModuleName;
	final int					mInstanceNumber;
	final String				mkstatName;
	final HashMap				mAttributes;
	
	public static class kstatAttribute
	{
		public final String		mName;
		public final Object		mValue;
		
		
			private static Object
		tryType( Class theClass, String input )
		{
			Object	value	= null;
			
			try
			{
				value	= ClassUtil.InstantiateFromString( theClass, input );
			}
			catch( Exception e )
			{
				// ignore
			}
			return( value );
		}
		
			private static Object
		createValue( String input )
		{
			Object	value	= tryType( Long.class, input );
			if ( value == null )
			{
				value	= tryType( Double.class, input );
			}
			if ( value == null )
			{
				value	= input;
			}
			
			return( value );
		}
		
			public
		kstatAttribute( String name, String value )
		{
			mName	= name;
			mValue	= createValue( value );
		}
			public String
		toString()
		{
			return( mName + "=" + mValue );
		}
	};
	
		public
	kstat(
		String				moduleName,
		int					instanceNumber,
		String				kstatName )
	{
		mModuleName		= moduleName;
		mkstatName		= kstatName;
		mInstanceNumber	= instanceNumber;
		mAttributes		= new HashMap();
	}
		public void
	addAttribute( kstatAttribute attr )
	{
		mAttributes.put( attr.mName, attr );
	}
	
		String
	getModuleName()
	{
		return( mModuleName );
	}
	
		int
	getInstanceNumber()
	{
		return( mInstanceNumber );
	}
	
		String
	getName()
	{
		return( mkstatName );
	}
	
		Class
	getAttributeType( String name )
	{
		final Object	value	= getValue( name );
		return( value.getClass() );
	}
	
		String
	getScopedName( char delim )
	{
		return( getScopedName( mModuleName, mInstanceNumber, mkstatName, delim ) );
	}
	
		String
	getScopedName(  )
	{
		return( getScopedName( ':' ) );
	}
	
		public static String
	getScopedName( String moduleName, int instanceNumber, String name, char delim)
	{
		return( moduleName + delim + instanceNumber + delim + name );
	}
	
		public static String
	getScopedName( String moduleName, int instanceNumber, String name )
	{
		return( getScopedName( moduleName, instanceNumber, name, ':' ) );
	}
	
		Set
	getAttributeNames()
	{
		return( mAttributes.keySet() );
	}

		public Object
	getValue( String attributeName )
	{
		final kstatAttribute	attr	= (kstatAttribute)mAttributes.get( attributeName );
		
		Object	value	= null;
		if ( attr != null )
		{
			value	= attr.mValue;
		}
		
		return( value );
	}
	
		public String
	toString()
	{
		return( getScopedName( ':' ) + "\n" + SmartStringifier.toString( mAttributes ) );
	}
};


