/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import com.sun.enterprise.admin.common.JMXFileTransfer;
import javax.management.MBeanServerConnection;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.appserv.management.base.UploadDownloadMgr;
import java.util.Iterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.FileNotFoundException;

public class CreateTransformationRuleCommand extends BaseTransformationRuleCommand
{
    private static final String RULE_LOCATION_OPTION = "rulefilelocation";
    private static final String APPLY_TO_OPTION = "applyto";
    private static final String ENABLED_OPTION = "enabled";
    private static final String WEB_SERVICE_OPTION = "webservicename";
   
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        try
        { 
            MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                                  getUser(), getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance(mbsc).getDomainRoot();
            //final Set s = domainRoot.getQueryMgr().queryJ2EETypeSet(XTypes.WEB_SERVICE_ENDPOINT_CONFIG);
            String webServiceName = getOption(WEB_SERVICE_OPTION);
            validateWebServiceName(webServiceName, true);
            WebServiceEndpointConfig wsc = 
                    getWebServiceEndpointConfig(mbsc, webServiceName, true);
            if (wsc == null)
                throw new CommandException(getLocalizedString("CannotFindWebservice"));
            String ruleName = (String) getOperands().get(0);
            String ruleLocation = getOption(RULE_LOCATION_OPTION);
            boolean enabled = getBooleanOption(ENABLED_OPTION);
            String applyTo = getOption(APPLY_TO_OPTION);
            // please remember the file needs to uploaded to the location mentioned, then only
            // transformation rule can be active.
			File ruleFile = new File(ruleLocation);
			String msg = null;
			
			if (! ruleFile.exists()) 
                msg = getLocalizedString("FileDoesNotExist", new Object[] {ruleLocation});
			else if(ruleFile.length() <= 0)
                msg = getLocalizedString("FileIsEmpty", new Object[] {ruleLocation});
			else if(! ruleFile.canRead())
                msg = getLocalizedString("FileNotReadable", new Object[] {ruleLocation});

			if(msg != null)
				throw new CommandValidationException(msg);
			
            String remoteLocation = uploadFileToServer(mbsc);
            //File uploadedFile = uploadFile(domainRoot, ruleLocation);
			
            CLILogger.getInstance().printDebugMessage("uploadedFile = " + 
                                            remoteLocation);
            wsc.createTransformationRuleConfig(ruleName,
                    remoteLocation, enabled, applyTo, null);

	    CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
						       new Object[] {name}));
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }        
    
    }

    /**
     *Uploads file to temp location on server.
     *@throws CommandException
     */
    private String uploadFileToServer(MBeanServerConnection mbsc) 
                        throws CommandException, IOException
    {
        String ruleLocation = getOption(RULE_LOCATION_OPTION);
        return new JMXFileTransfer(mbsc).uploadFile(ruleLocation);
    }
}
