/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import javax.management.MBeanServerConnection;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import java.util.Iterator;
import java.util.Set;

public class DeleteTransformationRuleCommand extends BaseTransformationRuleCommand
{
    private static final String WEB_SERVICE_OPTION = "webservicename";
   
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        try
        { 
            MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                                  getUser(), getPassword());
            //DomainRoot domainRoot = ProxyFactory.getInstance(mbsc).getDomainRoot();
            //final Set s = domainRoot.getQueryMgr().queryJ2EETypeSet(XTypes.WEB_SERVICE_ENDPOINT_CONFIG);
            String webServiceName = getOption(WEB_SERVICE_OPTION);
            validateWebServiceName(webServiceName, true);
            WebServiceEndpointConfig wsc = 
                    getWebServiceEndpointConfig(mbsc, webServiceName, false);
            if (wsc == null)
                throw new CommandException(getLocalizedString("CannotFindWebservice"));
            String ruleName = (String) getOperands().get(0);
           
            wsc.removeTransformationRuleConfig(ruleName);

	    CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
						       new Object[] {name}));
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }        
    
    }


    /**
     *  parse the operand to get the web service name
     *  Also validate if the operand is well formed.
     *  @throws CommandValidationException
     */
    private WebServiceEndpointConfig getWebServiceEndpointConfig(Set s) throws CommandException
    {
        // this webserviceName is fully qualified name
        String fqWebServiceName = getOption(WEB_SERVICE_OPTION);
        // extract the partially qualified web service endpoing config name
        int firstHashIdx = fqWebServiceName.indexOf("#");
        String wsName= null;
        if ( firstHashIdx != -1 ) {
            if ( firstHashIdx+1 == fqWebServiceName.length()) {
                // msg XXX
                throw new CommandException(getLocalizedString("InvalidFormatForWebservice"));
            }
            wsName =  fqWebServiceName.substring(firstHashIdx +1);
        }
        else
        {
            throw new CommandException(getLocalizedString("InvalidFormatForWebservice"));
        }
        final Iterator iter = s.iterator();
        while (iter.hasNext() )
        {
            final WebServiceEndpointConfig wsc = (WebServiceEndpointConfig)iter.next();
            CLILogger.getInstance().printDebugMessage(wsc.getName());
            if (wsc.getName().equals(wsName))
            {
                return wsc;
            }
        }
        return null;
    }
}
