/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import java.util.Vector;

public class JvmOptionsCommand extends GenericCommand {

    private static final String ERROR_MSG = "error-msg";
    private static final String LINE_SEPARATOR = 
            System.getProperty("line.separator");

    protected void handleReturnValue(Object retVal) {
        final String[] invalidOptions = (String[])retVal;
        if (invalidOptions.length > 0)
        {
            printErrorMsg();
            printInvalidJvmOptions(invalidOptions);
            throw new RuntimeException();
        }
    }

    void printErrorMsg() {
        final String key = (String)((Vector)getProperty(ERROR_MSG)).get(0);
        CLILogger.getInstance().printError(getLocalizedString(key));
    }

    void printInvalidJvmOptions(Object[] oa) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < oa.length; i++) {
            sb.append(oa[i].toString());
            if (i < oa.length - 1) {
                //separate only the options.
                sb.append(LINE_SEPARATOR);
            }
        }
        CLILogger.getInstance().printError(sb.toString());
    }
}
