/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import com.sun.enterprise.config.serverbeans.ServerTags;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import java.util.List;

public class ListMBeansCommand extends GenericCommand 
{
    private final static String ENABLED_OPERATION = "isMBeanEnabled"; 
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        if (!validateOptions())
            throw new CommandValidationException("Validation is false");

            //use http connector
        MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                              getUser(), getPassword());
        final String objectName = getObjectName();
        final Object[] params = getParamsInfo();
        final String operationName = getOperationName();
        final String[] types = getTypesInfo();

        try
        { 
	    //if (System.getProperty("Debug") != null) printDebug(mbsc, objectName);
            List returnValue = (List) mbsc.invoke(new ObjectName(objectName), 
					     operationName, params, types);
            if (returnValue.size() == 0)
            {
                CLILogger.getInstance().printDetailMessage(
                                            getLocalizedString("NoElementsToList"));
            }
            ObjectName objName;
            String target = getOperands().size() > 0 ? 
                            (String) getOperands().get(0):null;
            CLILogger.getInstance().printDebugMessage("target = " + target);
            CLILogger.getInstance().printDebugMessage("list size = " + returnValue.size());
            
            for (int ii=0; ii<returnValue.size(); ii++)
            {
                objName = (ObjectName) returnValue.get(ii);
                CLILogger.getInstance().printDebugMessage("objName = " + objName.toString());
                String mbeanName = (String) mbsc.getAttribute(objName, ServerTags.NAME);
                String mbeanObjName = (String) mbsc.getAttribute(objName, 
                                                                ServerTags.OBJECT_NAME);
                final String boolVal = (String) mbsc.getAttribute(objName, ServerTags.ENABLED);
                boolean enabled = Boolean.valueOf(boolVal);

                //CLILogger.getInstance().printDebugMessage("enabled = " + enabled);
                String printString = mbeanName + " " + mbeanObjName + " " + 
                                        (enabled ? getLocalizedString("Enabled")
                                                : getLocalizedString("Disabled"));
                CLILogger.getInstance().printMessage(printString);
            }
            
	    CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
						       new Object[] {name}));
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }        
    }
}
