/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

/**
   This class gets called when create-file-user command is invoked.
   This class will overwrite validOptions in GenericCommand to validate
   the userpassword option.  If the userpassword and passwordfile options
   are not entered in the command line and interactive is true, then
   CLI will prompt the user for the password.
 */
public class PasswordAliasCommand extends FileUserCommand
{
    private static final String ALIAS_USER_NAME = "aliasuser";
    private static final String ALIAS_PASSWORD  = "aliaspassword";
    
    
    protected String getPasswordOptionName() {
        return ALIAS_PASSWORD;
    }
    
    
    protected String getPasswordPrompt()
    {
        return "AliasPasswordPrompt";
    }
    

    protected String getPasswordConfirmationPrompt()
    {
        return "AliasPasswordConfirmationPrompt";
    }


    protected String getUserOptionName() 
    {
        return ALIAS_USER_NAME;
    }
    
    
    protected String getUserPrompt()
    {
        return "AliasUserPrompt";
    }
}
