/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

public class SSLCommand extends GenericCommand
{
    private static final String TYPE_OPTION = "type";
    private static final String TYPE_OPTION_VALUES = "http-listener|iiop-listener|iiop-service";
    private static final String TYPE_VALUE_NOT_REQUIRE_OPERAND = "iiop-service";

    public boolean validateOptions() throws CommandValidationException
    {
    	super.validateOptions();
        final String typeOption = getOption(TYPE_OPTION);
        if (!typeOption.matches(TYPE_OPTION_VALUES))
            throw new CommandValidationException(getLocalizedString(
                                                     "InvalidTypeOption"));
        if (!typeOption.matches(TYPE_VALUE_NOT_REQUIRE_OPERAND) &&
            getOperands().size() < 1)
        {
            throw new CommandValidationException(getLocalizedString(
                                                     "OperandIsRequired",
                                                     new Object[] {typeOption}));
        }
        return true;
        
    }

}
