/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CLILogger;

import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.DomainConfig;

/**
 *  Stops all the domains in the specified/default domaindir
 *  @version  $Revision: 1.3 $
 */
public class StopAppservCommand extends StopDomainCommand {
    
    /**
     *  An abstract method that validates the options
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }
    
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException 
    {
        CLILogger.getInstance().printWarning(getLocalizedString("CommandDeprecated",
                                                                new Object[] {name}));
        validateOptions();
        
        String[] domainsList = null;
        try
        {
            DomainConfig domainConfig = new DomainConfig(null, getDomainsRoot());
            DomainsManager manager = getFeatureFactory().getDomainsManager();
            domainsList = manager.listDomains(domainConfig);
        }
        catch(Exception e)
        {
            throw new CommandException(getLocalizedString("CommandUnSuccessful",
                                                     new Object[] {name} ), e);
        }
        boolean allDomainsStopped = true;

        if (domainsList.length == 0)
            throw new CommandException(getLocalizedString("NoDomainsToStop"));
        else
            CLILogger.getInstance().printDetailMessage(getLocalizedString("StoppingAppserv",
                                                             new Object[] {getDomainsRoot()}));
        
        for (int i = 0; i < domainsList.length; i++)
        {
            try
            {
                stopDomain(domainsList[i]);                
            }
            catch(Exception e)
            {
                allDomainsStopped = false;
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
                CLILogger.getInstance().printExceptionStackTrace(e);
                CLILogger.getInstance().printError(getLocalizedString("CannotStopDomainMsg",
                                                       new Object[] {domainsList[i]}));
            }
        }
        if (!allDomainsStopped)
        {
            throw new CommandException(getLocalizedString("CannotStopOneOrMoreDomains"));

        }
    }
    
}
