/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

class User 
{
    private BufferedReader fromUser;
    private BufferedWriter toUser;
    private String quit;
    private String prompt;
    
    User(Reader in, Writer out, String quitPrefix, String prompt){
        fromUser = new BufferedReader(in);
        toUser = new BufferedWriter(out);
        quit = quitPrefix;
        this.prompt = prompt;
    }
      /**
       * Return false iff the line read from the user starts with the
       * quit character. This is a blocking call, waiting on input
       * from the user
       */
    boolean wantsToContinue() throws IOException {
        toUser.write(prompt);
        toUser.newLine();
        toUser.flush();
        return !fromUser.readLine().startsWith(quit);
    }

    void handleException (Exception e) throws IOException {
        toUser.write(e.getMessage());
        toUser.flush();
    }
    
}
