/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.util.Iterator;
import java.util.Locale;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import java.util.NoSuchElementException;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class CLIManFileFinderTest extends TestCase {
  public void testEndOfIterator() {
	  CLIManFileFinder c = new CLIManFileFinder();
	  Locale l = new Locale("en", "UK", "v1");
	  Iterator it = c.getPossibleLocations("command", l);
	  for (int i = 0; i < 71; i++){
		it.next();
	  }
	  assertEquals("help/command.9m", (String) it.next());
	  assertTrue(!it.hasNext());
	  try {
		it.next();
		fail("Expected NoSuchElementException indicating we'd read beyond the end of the interator");
	  }
	  catch (NoSuchElementException nse){
	  }
		
  }
	
  public void testEndOfThirdSearch() {
	  CLIManFileFinder c = new CLIManFileFinder();
	  Locale l = new Locale("en", "UK", "v1");
	  Iterator it = c.getPossibleLocations("command", l);
	  for (int i = 0; i < 53; i++){
		it.next();
	  }
	  assertEquals("help/en/command.9m", (String) it.next());
	  assertEquals("help/command.1", (String) it.next());
  }
  public void testEndOfSecondSearch() {
	  CLIManFileFinder c = new CLIManFileFinder();
	  Locale l = new Locale("en", "UK", "v1");
	  Iterator it = c.getPossibleLocations("command", l);
	  for (int i = 0; i < 35; i++){
		it.next();
	  }
	  assertEquals("help/en/UK/command.9m", (String) it.next());
	  assertEquals("help/en/command.1", (String) it.next());
  }
  public void testEndOfFirstSearch() {
	  CLIManFileFinder c = new CLIManFileFinder();
	  Locale l = new Locale("en", "UK", "v1");
	  Iterator it = c.getPossibleLocations("command", l);
	  for (int i = 0; i < 17; i++){
		it.next();
	  }
	  assertEquals("help/en/UK/v1/command.9m", (String) it.next());
	  assertEquals("help/en/UK/command.1", (String) it.next());
  }
  
  public void testLocations() {
	  CLIManFileFinder c = new CLIManFileFinder();
	  Locale l = new Locale("en", "UK", "v1");
	  Iterator it = c.getPossibleLocations("command", l);
	  assertEquals("help/en/UK/v1/command.1", (String) it.next());
	  assertEquals("help/en/UK/v1/command.1m",(String) it.next());
	  assertEquals("help/en/UK/v1/command.2", (String) it.next());
	  for (int i = 0; i < 5; i++){
		it.next();
	  }
	  assertEquals("help/en/UK/v1/command.5", (String) it.next());
  }
  
		
  public void testNoLanguage() {
	  CLIManFileFinder c = new CLIManFileFinder();
	  Locale l = new Locale("", "UK", "v1");
	  assertEquals(1,c.getLocaleLocations(l).length);
	  assertEquals("", c.getLocaleLocations(l)[0]);
	}
	
  public void testNoCountry() {
	  CLIManFileFinder c = new CLIManFileFinder();
	  Locale l = new Locale("en", "", "v1");
	  assertEquals(2,c.getLocaleLocations(l).length);
	  assertEquals("/en", c.getLocaleLocations(l)[0]);
	  assertEquals("", c.getLocaleLocations(l)[1]);
	}

  public void testEmptyVariant(){
	CLIManFileFinder c = new CLIManFileFinder();
	Locale l = new Locale("en", "uk", "");
	assertEquals(3,c.getLocaleLocations(l).length);
	assertEquals("/en/UK", c.getLocaleLocations(l)[0]);
	assertEquals("/en", c.getLocaleLocations(l)[1]);
	  assertEquals("", c.getLocaleLocations(l)[2]);
  }
  public void testNoVariant(){
	CLIManFileFinder c = new CLIManFileFinder();
	Locale l = new Locale("en", "uk");
	assertEquals(3,c.getLocaleLocations(l).length);
	assertEquals("/en/UK", c.getLocaleLocations(l)[0]);
	assertEquals("/en", c.getLocaleLocations(l)[1]);
	  assertEquals("", c.getLocaleLocations(l)[2]);
  }
  
  public void testSimpleLocation() {
	CLIManFileFinder c = new CLIManFileFinder();
	Locale l = new Locale("en", "uk", "v1");
	assertEquals(4,c.getLocaleLocations(l).length);
	assertEquals("/en/UK/v1", c.getLocaleLocations(l)[0]);
	assertEquals("/en/UK", c.getLocaleLocations(l)[1]);
	assertEquals("/en", c.getLocaleLocations(l)[2]);
	assertEquals("", c.getLocaleLocations(l)[3]);
	
  }

  public CLIManFileFinderTest(String name){
	super(name);
  }

  protected void setUp() {
  }

  protected void tearDown() {
  }

  private void nyi(){
	fail("Not Yet Implemented");
  }

  public static void main(String args[]){
	if (args.length == 0){
	  junit.textui.TestRunner.run(CLIManFileFinderTest.class);
	} else {
	  junit.textui.TestRunner.run(makeSuite(args));
	}
  }
  private static TestSuite makeSuite(String args[]){
	final TestSuite ts = new TestSuite();
	for (int i = 0; i < args.length; i++){
	  ts.addTest(new CLIManFileFinderTest(args[i]));
	}
	return ts;
  }
}
