/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

/**
   Note that this test requires resources for testing. These resources
   are construct4ed from the two files P1 & P2 located in the current
   directory. If these file names are changed then the corresponding
   names in this submodules build.xml file should be changed also
*/
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import junit.framework.*;
import junit.textui.TestRunner;

/**
 *
 * @author jane.young@sun.com
 * @version $Revision: 1.4 $
 */

/**
   Execute these tests using gmake (and Ant) by:
   cd <framework>
   gmake ANT_TARGETS=CommandTest.java
*/

public class CommandTest extends TestCase {
    public void testGetDelimeterIndex(){
        assertEquals(3, testCommand.getDelimeterIndex("0123", "3", 0));
    }
    
    public void testLocalizedString(){
        assertEquals("Key not found", testCommand.getLocalizedString("a", (Object []) null));
        assertEquals("Key not found", testCommand.getLocalizedString("InvalidCommand"));
    }
    
    public void testGetSetProperty2(){
        testCommand.setProperties(new Properties());
        testCommand.setProperty("prop", "value");
        assertEquals("value", testCommand.getProperty("prop"));
    }
    
    public void testGetSetProperty1(){
        testCommand.setProperties(new Properties());
        testCommand.setProperty("prop", "value");
        assertEquals("value", testCommand.getProperty("prop"));
    }
    
    
    public void testGetSetProperty(){
        testCommand.setProperties(new Properties());
        assertEquals(null, testCommand.getProperty("prop"));
    }
    

    public void testSetGetIntegerOptions(){
        testCommand.setOption("number 1", "1");
        assertEquals(1, testCommand.getIntegerOption("number 1"));
    }
    
    public void testSetBooleanOptionsList(){
        final List l = new ArrayList();
        testCommand.setBooleanOptions(l);
        l.add("bool");
        testCommand.setOption("bool", "fargle");
        assertEquals("sampleCommand --bool=fargle", testCommand.toString());
    }
    
    
    public void testBooleanOptions(){
        assertTrue(!testCommand.getBooleanOption("bool"));
        testCommand.setOption("bool", "true");
        assertEquals("true", testCommand.getOption("bool"));
    }
    
        
    public void testGetSetOptions(){
        testCommand.setOption("key", "value");
        assertEquals("value", testCommand.getOption("key"));
        assertNull(testCommand.getOption("foo"));
        
    }
    
    public void testConstructorAndAccessors(){
        assertEquals("sampleCommand", testCommand.getName());
        assertTrue(testCommand.getOperands().isEmpty());
        assertTrue(testCommand.getOptions().isEmpty());
        assertEquals(null, testCommand.getUsageText());
        assertNull(testCommand.getProperties(""));
        assertEquals("Key not found", testCommand.getLocalizedString("fargle"));
        assertEquals("sampleCommand", testCommand.toString());
        
    }
    
      // test replacePattern method with different sets of operands
    public void testReplacePatternOperands() throws Exception{
        final String[] operands = new String[] {"abc=xyz", "$123", "#123", "", "//////", "abc:xyz=123:456$888=\"99:99\"", "foo-bar"};
        testCommand.setOperands(new Vector(Arrays.asList(operands)));
        assertEquals("first operand should be abc=xyz", "abc=xyz", testCommand.replacePattern("{#1}"));
        assertEquals("second operand should be $123", "$123", testCommand.replacePattern("{#2}"));
        assertEquals("third operand should be #123", "#123", testCommand.replacePattern("{#3}"));
        assertEquals("fourth operand should be empty", null, testCommand.replacePattern("{#4}"));
        assertEquals("fifth operand should be //////", "//////", testCommand.replacePattern("{#5}"));
        assertEquals("sixth operand should be abc:xyz=123:456$888=\"99:99\"", 
                     "abc:xyz=123:456$888=\"99:99\"", testCommand.replacePattern("{#6}"));
        assertEquals("seventh operand should be foo-bar", "foo-bar", testCommand.replacePattern("{#7}"));
        assertEquals("all operands should be",
                     "7=foo-bar," +
                     "6=abc:xyz=123:456$888=\"99:99\"," +
                     "5=//////,"+ 
                     "4=,"+
                     "3=#123,"+
                     "2=$123,"+
                     "1=abc=xyz", testCommand.replacePattern("7={#7},"+
                                                             "6={#6},"+
                                                             "5={#5},"+
                                                             "4={#4},"+
                                                             "3={#3},"+
                                                             "2={#2},"+
                                                             "1={#1}"));
    }


      // test replacePattern method with different sets of options
    public void testReplacePatternOptions() throws Exception{
        HashMap options = new HashMap();
        options.put("user", "admin");
        options.put("password", "adminadmin");
        options.put("host", "fuyako");
        options.put("port", "4848");
        options.put("property", "--D:${abc.xyz}=123:\"456\":88:99$01");
        options.put("empty", "");
        options.put("foo-bar", "foobar");
        testCommand.setOptions(options);

        assertEquals("first option should be admin", "admin", testCommand.replacePattern("{$user}"));
        assertEquals("second option should be adminadmin", "adminadmin", testCommand.replacePattern("{$password}"));
        assertEquals("third option should be fuyako", "fuyako", testCommand.replacePattern("{$host}"));
        assertEquals("fourth option should be 4848", "4848", testCommand.replacePattern("{$port}"));
        assertEquals("fifth option should be --D:${abc.xyz}=123:\"456\":88:99$01", 
                     "--D:${abc.xyz}=123:\"456\":88:99$01", testCommand.replacePattern("{$property}"));
        assertEquals("sixth option should be empty", null, testCommand.replacePattern("{$empty}"));
        assertEquals("seventh option should be foobar", "foobar", testCommand.replacePattern("{$foo-bar}"));
        assertEquals("all options", "user=admin,password=adminadmin,host=fuyako,port=4848,"+
                     "property=--D:${abc.xyz}=123:\"456\":88:99$01,empty=,foo-bar=foobar",
                     testCommand.replacePattern("user={$user},password={$password},host={$host},"+
                                                "port={$port},property={$property},empty={$empty},foo-bar={$foo-bar}"));

    }
	
  
    public CommandTest(String name){
        super(name);
    }

    Command testCommand = null;

    protected void setUp() {
        testCommand = new Command() {
                public void runCommand()
                    throws CommandException, CommandValidationException
                {
                }
                public boolean validateOptions() throws CommandValidationException
                {
                    return true;
                }
            };
        testCommand.setName("sampleCommand");
    }
  
  

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static Test suite(){
        TestSuite suite = new TestSuite(CommandTest.class);
        return suite;
    }

    public static void main(String args[]) throws Exception {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(CommandTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
}

