/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import junit.framework.*;
import java.util.ResourceBundle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;

/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.5 $
 */

public class GlobalsManagerTest extends TestCase {
      // For test purposes there're two properties files, one in this
      // directory (and package) and one in the directory above. The
      // one in this directory is for the framework package, the one
      // in the directory above is for the command package.
    private static final String getCommandPackageName(){
        return "com.sun.enterprise.cli";
    }
    
    public void testCommandStringLocalization() throws Exception {
        final ICommandEnvironment env = new Env();
        final GlobalsManager gm = new GlobalsManager(env);
        GlobalsManager.setInstance(gm);
        GlobalsManager.setBasePackage(getCommandPackageName());
        GlobalsManager.setPropertyFile("CommandPropertyFile");
        assertEquals("command property", GlobalsManager.getString("a"));
        assertEquals("command property", GlobalsManager.getString("a", (Object []) null));
        GlobalsManager.setBasePackage((String) null);
    }
        
    public void testCommandStringLocalizationNoBundle() {
        final ICommandEnvironment env = new Env();
        final GlobalsManager gm = new GlobalsManager(env);
        GlobalsManager.setInstance(gm);
        try {
            assertEquals("", GlobalsManager.getString("a"));
            fail("Expected error indicating no base package could be found");
        }
        catch (CommandException ce){
//            assertEquals("Can't find bundle for base name null.CommandPropertyFile, locale en_US", ce.getMessage());
            assertEquals("Can't find bundle for base name null.CommandPropertyFile, locale "+Locale.getDefault(), ce.getMessage());            
            assertNull(ce.getCause());
        }
    }

    public void testFrameworkStringLocalization() throws Exception {
        final ICommandEnvironment env = new Env();
        final GlobalsManager gm = new GlobalsManager(env);
        GlobalsManager.setInstance(gm);
        assertEquals("framework property", GlobalsManager.getFrameworkString("a", (Object []) null));
        assertEquals("framework property", GlobalsManager.getFrameworkString("a"));
    }
    
    
        
    public void testEnvironment(){
        final ICommandEnvironment env = new Env();
        final GlobalsManager gm = new GlobalsManager(env);
        final ICommandEnvironment env2 = new Env();
        gm.setGlobalsEnv(env2);
        assertEquals(env2, gm.getGlobalsEnv());
    }
    
    public void testSingletonMethods(){
        final ICommandEnvironment env = new Env();
        final GlobalsManager gm = new GlobalsManager(env);
        GlobalsManager.setInstance(gm);
        assertEquals(gm, GlobalsManager.getInstance());
    }
    
    public void testGetSetRemove() {
        final ICommandEnvironment env = new Env();
        final GlobalsManager gm = new GlobalsManager(env);
        gm.setOption("key", "value");
        assertEquals("value", gm.getOption("key"));
        gm.removeOption("key");
        assertNull(gm.getOption("key"));
    }
    
        
    public void testSimpleConstructionAndObservers() {
        final ICommandEnvironment env = new Env();
        final GlobalsManager gm = new GlobalsManager(env);
        assertEquals(env, gm.getGlobalsEnv());
    }

    public GlobalsManagerTest(String name){
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(GlobalsManagerTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new GlobalsManagerTest(args[i]));
        }
        return ts;
    }

    private class Env implements ICommandEnvironment 
    {
        HashMap h = new HashMap();
        
        public void setEnvironment(String name, String value){
            h.put(name, value);
        }
        
        public Object removeEnvironment( String name ){
            final Object result = h.get(name);
            h.remove(name);
            return result;
        }
        
        public HashMap getEnvironments(){
            return new HashMap(h);
        }
        
        public Object getEnvironmentValue(String key){
            return h.get(key);
        }
        
        public String toString(){
            return h.toString();
        }
        
        public int getNumEnvironments(){
            return h.size();
        }
    }
    
}
