/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import junit.framework.*;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class UserInputTest extends TestCase {
    public void testEncodingProblem() {
        try {
            ui.setEncoding("fee");
            fail("Expected an exception");
        }
        catch (IOException ie){
            assertEquals("fee", ie.getMessage());
        }
    }

    public void testEncoding() throws Exception {
        in = new ByteArrayInputStream("one\ntwo\nthree".getBytes());
        ui = new UserInput(in);
        ui.setEncoding("ISO-8859-1");
        assertEquals('o', ui.getChar());
        assertEquals("ne", ui.getLine());
        assertEquals("two", ui.getLine());
        assertEquals("three", ui.getLine());
    }
    
        
    
    public void testReading() throws Exception {
        in = new ByteArrayInputStream("one\ntwo\nthree".getBytes());
        ui = new UserInput(in);
        assertEquals('o', ui.getChar());
        assertEquals("ne", ui.getLine());
        assertEquals("two", ui.getLine());
        assertEquals("three", ui.getLine());
    }
    
        
    public void testSimpleCase() throws IOException {
        assertTrue(ui.isInteractive());
        ui.close();
    }

    public UserInputTest(String name){
        super(name);
    }

    ByteArrayInputStream in;
    
    UserInput ui;
    

    protected void setUp() {
        in = new ByteArrayInputStream(new byte[0]);
        ui = new UserInput(in);    
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(UserInputTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new UserInputTest(args[i]));
        }
        return ts;
    }
}
