/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import junit.framework.*;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class UserTest extends TestCase {
    public void testUser() throws Exception {
        final Pipe toUser = new Pipe();
        final Pipe fromUser = new Pipe();
        final String quit = "q";
        final String prompt = "Press return to continue, q then return to quit";
        
        final User user = new User( toUser.getReader(), fromUser.getWriter(), quit, prompt);
        toUser.writeLine("");
        assertTrue(user.wantsToContinue());
        assertEquals(prompt, fromUser.readLine());
        toUser.writeLine("123");
        assertTrue(user.wantsToContinue());
        assertEquals(prompt, fromUser.readLine());
        toUser.writeLine("123" + quit);
        assertTrue(user.wantsToContinue());
        assertEquals(prompt, fromUser.readLine());
        toUser.writeLine(quit + "1234");
        assertTrue(!user.wantsToContinue());
        assertEquals(prompt, fromUser.readLine());
        
    }

    public UserTest(String name){
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(UserTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new UserTest(args[i]));
        }
        return ts;
    }

    class Pipe
    {
        PipedWriter pw = new PipedWriter();
        PipedReader pr = new PipedReader();
        BufferedReader br = new BufferedReader(pr);
        BufferedWriter bw = new BufferedWriter(pw);
        
        BufferedWriter getWriter(){ return bw; }
        BufferedReader getReader() { return br; }

        Pipe() throws IOException { pr.connect(pw); }
        void writeLine(String s) throws IOException {
            bw.write(s);
            bw.newLine();
            bw.flush();
        }
        
        String readLine() throws IOException {
            return br.readLine();
        }
        boolean ready() throws IOException {
            return br.ready();
        }

        
    }

}
