/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MBeanServerBuilder.java
 *
 * Created on January 26, 2003, 12:14 PM
 */

package com.sun.enterprise.admin.jmx;

import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import com.sun.jmx.mbeanserver.JmxMBeanServer;
import com.sun.jmx.interceptor.ForwardingMBeanServerInterceptor;

/**
 *
 * @author  sridatta
 */
public class AppServerMBeanServerBuilder extends javax.management.MBeanServerBuilder {
    
    /** Creates a new instance of MBeanServerBuilder */
    public AppServerMBeanServerBuilder() {
    }
    
    /**
    This method creates a new MBeanServerDelegate for a new MBeanServer. 
     When creating a new MBeanServer the MBeanServerFactory first calls 
     this method in order to create a new MBeanServerDelegate. 
     Then it calls newMBeanServer(defaultDomain,outer,delegate) passing the delegate 
     that should be used by the MBeanServer implementation. 
     Note that the passed delegate might not be directly the MBeanServerDelegate that 
     was returned by this method. It could be, for instance, a new object wrapping
     the previously returned object. 

     */
    
     public MBeanServer newMBeanServer(String defaultDomain, 
                                    MBeanServer outer, 
                                    MBeanServerDelegate delegate) {
         JmxMBeanServer jmxMBS = (JmxMBeanServer)JmxMBeanServer.newMBeanServer(defaultDomain,outer,delegate,
					     true);
         ForwardingMBeanServerInterceptor appServerInterceptor = 
                                    new AppServerMBeanServerInterceptor();
         try {
            appServerInterceptor.insertFirst(jmxMBS);
         } catch(Exception e) {
            e.printStackTrace();
         }
         return jmxMBS;
     }
       
     /**    
      This method creates a new MBeanServer implementation object. When creating a new 
      MBeanServer the MBeanServerFactory first calls newMBeanServerDelegate() in 
      order to obtain a new MBeanServerDelegate for the new MBeanServer. Then it 
      calls newMBeanServer(defaultDomain,outer,delegate) passing the delegate that 
      should be used by the MBeanServer implementation. 
      Note that the passed delegate might not be directly the MBeanServerDelegate that
      was returned by this implementation. It could be, for instance, a new object
      wrapping the previously returned delegate. 

      The outer parameter is a pointer to the MBeanServer that should be passed
      to the MBeanRegistration interface when registering MBeans inside the 
      MBeanServer. If outer is null, then the MBeanServer implementation must 
      use its own this reference when invoking the MBeanRegistration interface. 

      This makes it possible for a MBeanServer implementation to wrap another MBeanServer
      implementation, in order to implement, e.g, security checks, or to prevent 
      access to the actual MBeanServer implementation by returning a pointer to a wrapping object. 

        Parameters:
        defaultDomain - Default domain of the new MBeanServer.
        outer - A pointer to the MBeanServer object that must be passed to the MBeans when invoking their MBeanRegistration interface.
        delegate - A pointer to the MBeanServerDelegate associated with the new MBeanServer. The new MBeanServer must register this MBean in its MBean repository. 
        Returns:
        A new private implementation of an MBeanServer.
      
      */
    public MBeanServerDelegate newMBeanServerDelegate()  {
        return JmxMBeanServer.newMBeanServerDelegate();
     }
}
