/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

import javax.management.*;
import java.util.*;

//import com.sun.enterprise.management.util.J2EEManagementObjectUtility;
//import com.sun.enterprise.tools.admin.RealmTool;

public class J2EEServerMdl extends J2EEManagedObjectMdl {

    /**
     * required for storing restart flag
     */
    private boolean restartRequired = false;
    
    private String serverVendor = "Sun Microsystems, Inc.";
    private static String MANAGED_OBJECT_TYPE = "J2EEServer";
    
    public J2EEServerMdl() {
        /*
        super(System.getProperty(com.sun.enterprise.server.J2EEServer.J2EE_APPNAME, "j2ee") +
            System.getProperty(com.sun.enterprise.server.J2EEServer.J2EE_SERVER_ID_PROP, "100"), false, false, false);
        //this.serverName = System.getProperty(com.sun.enterprise.server.J2EEServer.J2EE_APPNAME) + System.getProperty(com.sun.enterprise.server.J2EEServer.J2EE_SERVER_ID_PROP);
         */
        super("j2ee100", false, false, false);
    }

/** 
* A list of all applications deployed on this J2EEServer. 
* @supplierCardinality 0..* 
* / 
    public String[] getdeployedObjects(){
        Set apps = findNames("j2eeType=J2EEApplication,J2EEServer=" + getJ2EEServer());
        apps.addAll(findNames("j2eeType=EJBModule,J2EEServer=" + getJ2EEServer()));
        apps.addAll(findNames("j2eeType=WebModule,J2EEServer=" + getJ2EEServer()));
        apps.addAll(findNames("j2eeType=ResourceAdapterModule,J2EEServer=" + getJ2EEServer()));
        apps.addAll(findNames("j2eeType=AppClientModule,J2EEServer=" + getJ2EEServer()));

        Iterator it = apps.iterator();
        String [] deployed = new String[apps.size()];
        int i =0;
        while(it.hasNext()) {
            deployed[i++] = ((ObjectName)it.next()).toString();
        }
        return deployed;
    }

/** 
* A list of resources available to this server. 
* @supplierCardinality 0..* 
* / 
    public String[] getresources() {
        Set res = findNames("j2eeType=JCAResource,J2EEServer=" + getJ2EEServer());
        res.addAll(findNames("j2eeType=JavaMailResource,J2EEServer=" + getJ2EEServer()));
        res.addAll(findNames("j2eeType=JDBCResource,J2EEServer=" + getJ2EEServer()));
        res.addAll(findNames("j2eeType=JMSResource,J2EEServer=" + getJ2EEServer()));
        res.addAll(findNames("j2eeType=JNDIResource,J2EEServer=" + getJ2EEServer()));
        res.addAll(findNames("j2eeType=JTAResource,J2EEServer=" + getJ2EEServer()));
        res.addAll(findNames("j2eeType=RMI_IIOPResource,J2EEServer=" + getJ2EEServer()));
        res.addAll(findNames("j2eeType=URLResource,J2EEServer=" + getJ2EEServer()));
        res.addAll(findNames("j2eeType=AdminObjectResource,J2EEServer=" + getJ2EEServer()));
        Iterator it = res.iterator();
        String [] resources = new String[res.size()];
        int i =0;
        while(it.hasNext()) {
            resources[i++] = ((ObjectName)it.next()).toString();
        }
        return resources;
    }

/** 
* A list of nodes that this J2EEServer spans. 
* @supplierCardinality 1..* 
* / 
    public String[] getnodes(){
        try {
        	return new String [] { (java.net.InetAddress.getLocalHost()).toString() };
        } catch(Exception e) {
            return new String[0];
        }
    }

/** 
* A list of all Java virtual machines on which this J2EEServer has running threads. 
* @supplierCardinality 0..* 
* / 
    public String[] getjavaVMs() {
        Set vms = findNames("j2eeType=JVM");

        Iterator it = vms.iterator();
        String [] jvms = new String[vms.size()];
        int i =0;
        while(it.hasNext()) {
            jvms[i++] = ((ObjectName)it.next()).toString();
        }
        return jvms;
    }

	/**
	* Identifies the J2EE platform vendor of this J2EEServer. The value of serverVendor is specified by the vendor.
	*/
    public String getserverVendor(){
        return serverVendor;
    }

    /**
	* Identifies the J2EE platform version of this J2EEServer. The value of serverVersion is specified by the vendor.
	* /
    public String getserverVersion() {
        return com.sun.enterprise.Version.fullVersion;
    }
    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this method and return the appropriate type string.
     */
    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }
    
    /**
     * The name of the J2EEManagedObject. All managed objects must have a unique name within the context of the management
     * domain. The name must not be null.
     */
    public String getobjectName() {
        Set s = findNames("j2eeType="+getj2eeType()+",name="+getJ2EEServer());
        Object [] objs = s.toArray();
        if (objs.length > 0) {
        	String name = ((ObjectName)objs[0]).toString();
        	return name;
        } else {
            return null;
        }
    }
    
    //Resources section START
    
    /*
    public void addJdbcDataSource(  String jndiName, 
                                    String url) 
                                    throws Exception {
        J2EEManagementObjectUtility.addJdbcDataSource(jndiName, 
                                    url);
    }
    
    public void addJdbcXADataSource(  String jndiName, 
                                    String userName, 
                                    String password, 
                                    String datasourceClassname,
                                    String[] propNames,
                                    String[] propValues) 
                                    throws Exception {
        J2EEManagementObjectUtility.addJdbcXADataSource(jndiName, 
                                    userName, 
                                    password,
                                    datasourceClassname,
                                    propNames,
                                    propValues);
    }
      
     */
    
    /**
     * Add a JdbcDriver Dynamically 
     */
    
    /*
    public void addJdbcDriver(String driver) throws Exception {
        J2EEManagementObjectUtility.addJdbcDriver(driver);
    }
    
    public void addConnectorResource(   String jndiName,
                                        String appName,
                                        String connectorName,
                                        String userName,
                                        String password,
                                        String cfType,
                                        String[] propNames,
                                        String[] propValues) 
                                        throws Exception {
                                             
        J2EEManagementObjectUtility.addConnectorResource(jndiName, 
                                        appName,
                                        connectorName,
                                        userName,
                                        password,
                                        cfType,
                                        propNames,
                                        propValues);
    }
    
    public void addJMSDestination(   String jndiName, 
                                        String resType)
                                        throws Exception {
        J2EEManagementObjectUtility.addJMSDestination(jndiName, 
                                        resType);
    }
        
    public void addJMSConnectionFactory(   String jndiName, 
                                        String resType,
                                        String[] propNames,
                                        String[] propValues)
                                        throws Exception {
        J2EEManagementObjectUtility.addJMSConnectionFactory(jndiName, 
                                        resType,
                                        propNames,
                                        propValues);
    }
    
    public void addAdminObjectResource (String jndiName,
                                                String appName,
                                                String connectorName,
                                                String adminObjectType,
                                                String[] propNames, 
                                                String[] propValues) 
                                                throws Exception {
        J2EEManagementObjectUtility.addAdminObjectResource(jndiName,
                                                appName,
                                                connectorName,
                                                adminObjectType,
                                                propNames, 
                                                propValues);
    }
     */
    
    /**
     * Set of ObjectName
     * see tests1.3/mejb
     */
    
    /*
    public Set listResources(String resourceType) {
        return findNames("j2eeType="+resourceType + ",J2EEServer="+this.getJ2EEServer());
    }
    
    public void removeResource(String resourceType, String name) throws Exception {
        J2EEManagementObjectUtility.removeResource(resourceType, name);
    }
    //Resources section END

    // Realm section START
    public ArrayList showRealms() throws Exception {
        return RealmTool.showRealms();
    }

    public ArrayList listUsersInRealm(String realmName) throws Exception {
        return RealmTool.listUsersInRealm(realmName);
    }

    public ArrayList listGroupsInDefaultRealm() throws Exception {
        return RealmTool.listGroupsInDefaultRealm();
    }

    public void addUserToDefaultRealm(String username, String password, String[] groupName)
                                                                           throws Exception {
        RealmTool.addUserToDefaultRealm(username, password, groupName);
    }

    public void addGroupToDefaultRealm(String groupName) throws Exception {
        boolean b = RealmTool.addGroupToDefaultRealm(groupName);
        if(b) restartRequired = true;
    }

    public void importCertificate(String certificateFileName) throws Exception {
        boolean b = RealmTool.importCertificate(certificateFileName);
        if(b) restartRequired = true;
    }

    public ArrayList getUserGroups(String username) throws Exception {
        return RealmTool.getUserGroups(username);
    }

    public void removeUserFromRealm(String realmName, String username) throws Exception {
        boolean b = RealmTool.removeUserFromRealm(realmName, username);
        if(b) restartRequired = true;
    }

    public void removeGroupFromDefaultRealm(String groupName) throws Exception {
        boolean b = RealmTool.removeGroupFromDefaultRealm(groupName);
        if(b) restartRequired = true;
    }
    // Realm section END
    
     */
    
    //General Purpose APIs START
    
    /**
     * This API can be used to see if any change you made through these mbeans
     * require a server restart
     * NYI
     */
    /*
    public boolean isRestartNeeded() {
	return restartRequired;
    }
    //General Purpose APIs
     */
}
