/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.agent;

import java.rmi.Naming;
import javax.management.*;

/** 
 * RemoteListenerConnectors are instantiated by the ListenerRegistry
 * with the address of the callback port of the RemoteEventListener
 * and then registered with the MBeanServer by the MEJB.
 *
 * @author Hans Hrasna
 */
public class RemoteListenerConnector implements NotificationListener, java.io.Serializable {

    private String proxyAddress;	// the RMI address of the remote event listener
    private RemoteEventListener listener = null;  //the remote event listener
    private MBeanServer server = null;    // the MBeanServer holds the object this is listening to
                                   		  // which is set when this is registered in the MEJB
    private String id = hashCode() + ":" + System.currentTimeMillis();
    private boolean debug = false;

    public RemoteListenerConnector(String address) {
        proxyAddress = address;
    }

    public void handleNotification(Notification evt, Object h) {
        try {
            if (debug) System.out.println("RemoteListenerConnector.handleNotification()");
            if (listener == null) {
            	listener = (RemoteEventListener)Naming.lookup(proxyAddress);
            }
            listener.handleNotification(evt, h);
        } catch (java.rmi.RemoteException ce) {
            if (server != null) {
                if (debug) System.out.println("RemoteListenerConnector.server.removeNotificationListener("+ (ObjectName)evt.getSource() + ", " + this + ")");
                try {
                    server.removeNotificationListener((ObjectName)evt.getSource(), this);
                } catch (javax.management.ListenerNotFoundException e) {
                    if(debug) System.out.println(toString() + ": " + e); //occurs normally if event was fowarded from J2EEDomain
                } catch (Exception e1) {
                    System.out.println(toString() + ": " + e1);
                }
            }
        } catch (Exception e) {
            System.out.println(toString() + ": " + e);
            if (debug) {
            	try {
                	System.out.println("Naming.list(\"//localhost:1100\")");
                	String [] names = Naming.list("//localhost:1100");
            		for(int x=0;x<names.length;x++) {
                		System.out.println("names["+x+"] = " + names[x]);
            		}
            	} catch(Exception e1) {
                	e1.printStackTrace();
            	}
            }
        }
    }

    public String getId() {
        return id;
    }

    public void setMBeanServer(MBeanServer s) {
        server = s;
    }
}
