/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;


/**
	Base interface for all OperationStatus objects.
 */
public interface OperationStatus extends MapCapable
{
	/**
		Key used to look up the Throwable (if any) from the Map.
		The value returned is a java.lang.Throwable.
	 */
	public static final String	THROWABLE_KEY		= "ThrowableKey";
	
	/**
		Key used to look up the status code (if any) from the Map.
		The value returned is an Integer whose intValue() is the
		status code.  Corresponds to {@link #getStatusCode}.
	 */
	public static final String	STATUS_CODE_KEY		= "StatusCodeKey";
	
	/**
		If there is no explicit status code, an operation is considered
		successful if nothing was thrown.
		<p>
		Legal status codes include:
		<ul>
		<li>#STATUS_CODE_SUCCESS</li>
		<li>#STATUS_CODE_FAILURE</li>
		<li>#STATUS_CODE_WARNING</li>
		<li><i>any other status codes defined by sub-interfaces/subclasses</i></li>
		</ul>
		
		@return the status code
	 */
	public int			getStatusCode();
	
	/**
		If a Throwable was thrown, this implies some degree of failure
		from partial to total.
		
		@return any Throwable that was thrown
	 */
	public Throwable	getThrowable();
	
	/**
		Status code indicating success of the operation.
	 */
	public final int	STATUS_CODE_SUCCESS	= 2;
	
	/**
		Status code indicating failure of the operation.
	 */
	public final int	STATUS_CODE_FAILURE	= 0;
	
	/**
		Status code indicating success, with warning.
	 */
	public static final int STATUS_CODE_WARNING = 1; 
}








