/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;



import javax.management.NotificationEmitter;

import com.sun.appserv.management.base.AMX;

/**
	All Config MBeans must extend this interface, whether they
	represent elements or whether they are managers. Extending
	this interface implies that the class is part of the  API
	for configuration.
	<p>
	All AMXConfig s are required to implement NotificationEmitter.
	A Config  must issue {@link javax.management.AttributeChangeNotification} when
	changes are made to the configuration.
 */
public interface AMXConfig extends AMX
{
	/**
		The type of the Notification emitted when a config element
		is created.
	 */
	public final String	CONFIG_CREATED_NOTIFICATION_TYPE	=
		"com.sun.appserv.management.config.ConfigCreated";
    
	/**
		The type of the Notification emitted when a config element
		is removed.
	 */
	public final String	CONFIG_REMOVED_NOTIFICATION_TYPE	=
		"com.sun.appserv.management.config.ConfigRemoved";
		
	/**
		The key within the Notification's Map of type
		CONFIG_REMOVED_NOTIFICATION_TYPE which yields the ObjectName
		of the  created or removed config.
	 */
	public final String	CONFIG_OBJECT_NAME_KEY	=
					"ConfigObjectName";




}
