/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 

package com.sun.appserv.management.config;

import java.util.Map;

/**
	Supports creation and removal of server references.
*/
public interface ClusterRefConfigCR extends ConfigRemover
{
    public final static String	LB_POLICY_KEY		= "LBPolicy";

    public final static String	LB_POLICY_MODULE_KEY    = "LBPolicyModule";

    /**
      Creates a new cluster-ref for an lb-config.
      @param clusterName A reference to the name of a cluster.
      @param reserved	reserved for future use
      @return A proxy to the ClusterRefConfig MBean. 
     */
    public ClusterRefConfig createClusterRefConfig(
        String clusterName, Map<String,String> reserved);

    /**
    Creates a new cluster-ref.

    * @param referencedClusterName name of the cluster.
    * @param lbPolicy load balancing policy for this cluster
    * @param lbPolicyModule absolute path to the shared library implementing 
    * the user-defined policy.
    * @return A proxy to the ClusterRefConfig MBean.
    */
    public ClusterRefConfig createClusterRefConfig(
        String referencedClusterName, String lbPolicy, String lbPolicyModule);
    /**
      Removes a cluster-ref for an lb-config.
      @param clusterName A reference to the name of a cluster.
     */
    public void removeClusterRefConfig(String clusterName );
}
