/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;




/**
    Configuration for the &lt;connector-connection-pool&gt; element.                                                  
    <p>
    connector-connection-pool defines configuration used to create    
    and manage a pool of connections to a EIS. Pool definition is     
    named, and can be referred to by multiple connector-resource      
    elements (See connector-resource).                                                    
    <p>                             
    Each named pool definition results in a pool instantiated at server        
    start-up. Pool is populated when accessed for the first time. If two or    
    more connector-resource elements point to the same                         
    connector-connection-pool element, they are using the same pool of         
    connections, at run time.                                                  
    <p>
    There can be more than one pool for one connection-definition in one       
    resource-adapter.                                                     
*/

public interface ConnectorConnectionPoolConfig
    extends NamedConfigElement, Description, PropertiesAccess,
        Container, ResourceRefConfigReferent
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.CONNECTOR_CONNECTION_POOL_CONFIG;

	/**    
        Specifies if the connection that is about to   
        be returned is to be validated by the container.
      */
    public boolean  getConnectionValidationRequired();
    
	/**
	    See {@link #getConnectionValidationRequired}.
	*/
    public void     setConnectionValidationRequired( final boolean required );
    
	/**             
        Unique name, identifying one connection-definition in a       
        Resource Adapter. Currently this is ConnectionFactory type.  
	*/
	public String   getConnectionDefinitionName();
	
	/**
	    See {@link #getConnectionDefinitionName}.
	*/
	public void     setConnectionDefinitionName( final String value );

	/**                                                
        Indicates if all connections in the pool must be closed       
        should a single connection fail validation. The default is    
        false. One attempt will be made to re-establish failed        
        connections.               
	*/
	public boolean  getFailAllConnections();
	
	/**
	    See {@link #getFailAllConnections}.
	*/
	public void     setFailAllConnections( final boolean value );

	/**
        Maximum time in seconds, that a connection can remain idle in 
        the pool. After this time, the pool implementation can close  
        this connection. Note that this does not control connection   
        timeouts enforced at the database server side. Adminsitrators 
        are advised to keep this timeout shorter than the EIS         
        connection timeout (if such timeouts are configured on the    
        specific EIS), to prevent accumulation of unusable connection 
        in Application Server.                           
	*/
	public String   getIdleTimeoutInSeconds();
	
	/**
	    See {@link #getIdleTimeoutInSeconds}.
	*/
	public void     setIdleTimeoutInSeconds( final String value );

	/**
        Maximum number of conections that can be created.
	*/
	public String   getMaxPoolSize();
	
	/**
	    See {@link #getMaxPoolSize}.
	*/
	public void     setMaxPoolSize( final String value );

	/**
        Amount of time the caller will wait before getting a          
        connection timeout. The default is 60 seconds. A value of 0   
        will force caller to wait indefinitely.            
	*/
	public String   getMaxWaitTimeInMillis();
	
	/**
	    See {@link #getMaxWaitTimeInMillis}.
	*/
	public void     setMaxWaitTimeInMillis( final String value );


	/**
        Number of connections to be removed when                      
        idle-timeout-in-seconds timer expires. Connections that have  
        idled for longer than the timeout are candidates for removal. 
        When the pool size reaches steady-pool-size, the connection   
        removal stops.                           
	*/
	public String   getPoolResizeQuantity();
	
	/**
	    See {@link #getPoolResizeQuantity}.
	*/
	public void     setPoolResizeQuantity( final String value );

	/**
        Name of resource adapter. Name of .rar file is    
        taken as the unique name for the resource adapter.
	*/
	public String   getResourceAdapterName();
	
	/**
	    See {@link #getResourceAdapterName}.
	*/
	public void     setResourceAdapterName( final String value );

	/**                           
        Minimum and initial number of connections maintained in the   
        pool.                                        
	*/
	public String   getSteadyPoolSize();
	
	/**
	    See {@link #getSteadyPoolSize}.
	*/
	public void     setSteadyPoolSize( final String value );
	
	/**                                                   
        Indicates the level of transaction support that this pool     
        will have. Possible values are "XATransaction",               
        "LocalTransaction" and "NoTransaction". This attribute will   
        override that transaction support attribute in the Resource   
        Adapter in a downward compatible way, i.e it can support a    
        lower/equal transaction level than specified in the RA, but   
        not a higher level.                  
        
		@see TransactionSupportValues
	*/
	public String   getTransactionSupport();
	
	/**
		 See {@link #getTransactionSupport}.
	*/
	public void     setTransactionSupport( final String value );
	
	/**
	    @return Map of all SecurityMapConfig contained in this item.
	 */
	public Map<String,SecurityMapConfig>    getSecurityMapConfigMap();
	
	/**
	    At least one of 'principals' and 'userGroups' must be non-null.
	 */
	    public SecurityMapConfig
	createSecurityMapConfig(
	    final String    name,
	    final String    backendPrincipalUsername,
	    final String    backendPrincipalPassword,
	    final String[]  principals,
	    final String[]  userGroups );
	
	/**
	    Remove the specified SecurityMapConfig.
	 */
	public void removeSecurityMapConfig( String name );
}






