/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/JMXConnectorConfig.java,v 1.4 2005/12/25 03:49:38 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:49:38 $
 */

package com.sun.appserv.management.config;

import java.util.Map;



import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;

/**
	 Configuration for the &lt;jmx-connector&gt; element.
*/
public interface JMXConnectorConfig
	extends Enabled, NamedConfigElement, PropertiesAccess, SSLConfigContainer
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.JMX_CONNECTOR_CONFIG;
		
	public String	getProtocol();

	public void		setProtocol( String value );

	public String	getAddress();

	public String	getPort();

	public boolean	getAcceptAll();

	public void		setAcceptAll( final boolean value );

	public String	getAuthRealmName();

	public boolean	getSecurityEnabled();

	public void		setSecurityEnabled( final boolean value );

}
