/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/LBConfig.java,v 1.12 2005/12/25 03:49:41 tcfujii Exp $
 * $Revision: 1.12 $
 * $Date: 2005/12/25 03:49:41 $
 */

package com.sun.appserv.management.config;

import java.util.Map;
import java.util.Date;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;

/**
   Configuration for the lb-config element.
   @see com.sun.appserv.management.ext.lb.LoadBalancer 
 */
public interface LBConfig extends 
    AMXConfig, PropertiesAccess, NamedConfigElement,
        ServerRefConfigCR, ClusterRefConfigCR, Container {
    
    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String	J2EE_TYPE = XTypes.LB_CONFIG;

    /**
      Returns the period, in seconds, within which a server must return a response 
      or otherwise it will be considered unhealthy. Must be greater than or 
      equal to 0. 
     */
    public String getResponseTimeoutInSeconds();

    /**
      Set the period, in seconds, within which a server must return a response or
      otherwise it will be considered unhealthy. Default value is 60 seconds. 
      Must be greater than or equal to 0. A value of 0 effectively turns off 
      this check functionality, meaning the server will always be considered healthy.
     */
    public void	setResponseTimeoutInSeconds(final String responseTimeoutInSeconds);

    /**
      Returns a boolean flag indicating how load-balancer will route HTTPS
      requests. If true, then an HTTPS request to the load-balancer will 
      result in an HTTPS request to the server; if false, then HTTPS requests 
      to the load-balancer result in HTTP requests to the server. 
     */
    public boolean getHttpsRouting();

    /**
      Set the boolean flag indicating how load-balancer will route HTTPS
      requests. If true, then an HTTPS request to the load-balancer will 
      result in an HTTPS request to the server; if false, then HTTPS requests 
      to the load-balancer result in HTTP requests to the server. 
      Default is to use HTTP (i.e. value of false);
     */
    public void	setHttpsRouting(final boolean value);
    
    /**
      Returns the maximum period, in seconds, that a change to the load
      balancer configuration file takes before it is detected by
      the load balancer and the file reloaded. A value of 0
      indicates that reloading is disabled. 
     */
    public String getReloadPollIntervalInSeconds();

    /**
      Set the maximum period, in seconds, that a change to the load balancer 
      configuration file takes before it is detected by the load balancer and 
      the file reloaded. A value of 0 indicates that reloading is disabled. 
      Default period is 1 minute (60 seconds)
     */
    public void	setReloadPollIntervalInSeconds(final String reloadPollIntervalInSeconds);

    /**
      Returns the boolean flag that determines whether monitoring is switched
      on or not. Default is that monitoring is switched off (false)
     */
    public boolean getMonitoringEnabled();

    /**
      Set the boolean flag that determines whether monitoring is switched
      on or not. Default is that monitoring is switched off (false)
     */
    public void	setMonitoringEnabled(final boolean value);
   
    /**
      Returns the boolean flag that determines whether a route cookie is or is
      not enabled.
     */
    public boolean getRouteCookieEnabled();

    /**
      Set the boolean flag that determines whether a route cookie is or is
      not enabled. Default is enabled (true).
     */
    public void	setRouteCookieEnabled(final boolean value);
    
    /**
      Calls Container.getContaineeMap(XTypes.CLUSTER_REF_CONFIG ).
      @return Map of ClusterRefConfig MBean proxies, keyed by name.
      @see com.sun.appserv.management.base.Container#getContaineeMap
     */
    public Map<String,ClusterRefConfig> getClusterRefConfigMap();

    /**
      Calls Container.getContaineeMap(XTypes.SERVER_REF_CONFIG ).
      @return Map of ServerRefConfig MBean proxies, keyed by name.
      @see com.sun.appserv.management.base.Container#getContaineeMap
     */
    public Map<String,ServerRefConfig> getServerRefConfigMap();    
}
