/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/ResourceRefConfigCR.java,v 1.5 2006/03/09 20:30:24 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:24 $
 */

package com.sun.appserv.management.config;

import java.util.Map;

/**
	Allows creation and removal of ResourceRefConfig.
*/
public interface ResourceRefConfigCR extends ConfigRemover
{
	/**
		Creates a new resource-ref element for the given target
		@param referencedResourceName resource name
		@param optional Map of optional attributes.
		@return A proxy to the ResourceRefConfig MBean.
	 */
	public ResourceRefConfig createResourceRefConfig(String referencedResourceName,
	            Map<String,String> optional);
	    
	/**
		Creates a new resource-ref element for the given target
		@param referencedResourceName resource name
		@return A proxy to the ResourceRefConfig MBean.
	 */
	public ResourceRefConfig createResourceRefConfig(String referencedResourceName);


	/**
		Creates a new resource-ref element.
		@param referencedResourceName resource name
		@param enabled
		@return A proxy to the ResourceRefConfig MBean.
	 */
	public ResourceRefConfig createResourceRefConfig(String referencedResourceName, 
	        boolean enabled);

	/**
	 */
	public void	removeResourceRefConfig( String name );
}
