/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentProgress.java
 *
 * Created on April 8, 2004, 9:35 AM
 */

package com.sun.appserv.management.deploy;

import java.util.Map;
import java.util.Locale;

import javax.management.openmbean.CompositeData;

import com.sun.appserv.management.base.MapCapable;



/**
	Interface to provide deployment feedback while deployment 
	is executing in the server backend.

	This interface may be instantiated by using routines in
	{@link com.sun.appserv.management.deploy.DeploymentSupport}
 */
public interface DeploymentProgress extends MapCapable
{
	/**
		Value of the MAP_CAPABLE_TYPE_KEY when turned into a Map.
	 */
	public final static String	DEPLOYMENT_PROGRESS_CLASS_NAME	=
			"com.sun.appserv.management.deploy.DeploymentProgress";


	/**
		Key for the progress percent as returned by getProgressPercent().
	 */
	public static final String	PROGRESS_PERCENT_KEY	= "ProgressPercent";
	
	/**
		Key for the Description as returned by getDescription().
	 */
	public static final String	DESCRIPTION_KEY	= "Description";
	
	/**
		Key prefix for the Description as returned by getDescription().  The key for
		a given locale is LOCALIZED_DESCRIPTION_KEY_BASE + "_" + Locale.toString()
	 */
	public static final String	LOCALIZED_DESCRIPTION_KEY_BASE	= "LocalizedDescription";

    
    /**
     * @return the deployment progress number between 0 and 
     * 100 (deployment finished). This number is purely 
     * indicative and cannot be used to calculate actual 
     * remaining time
     * @return number from 0 to 100 indicating status
     */
    public byte getProgressPercent();
    
    /**
     * @return the last meaningful description of the current
     * deployment operation
     */
    public String getDescription();
    
    /**
     * @return the last meaningful localized description of 
     * the current deployment operation.
     */
    public String getLocalizedDescription(Locale locale);
}
