/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.deploy;

import java.util.Set;
import java.util.Map;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.io.FileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

import com.sun.appserv.management.base.MapCapableBase;
import com.sun.appserv.management.deploy.DeploymentSource;


/**
 */

public final class DeploymentSourceImpl
	extends MapCapableBase
	implements DeploymentSource
{
	/**
		Key corresponding to getArchive()
	 */
	public static final String	ARCHIVE_FILE_KEY	= "Archive";
	
	/**
		Key corresponding to isComplete()
	 */
	public static final String	IS_COMPLETE_ARCHIVE_KEY	= "IsCompleteArchive";
	
	/**
		Key corresponding to getEntriesAdded()
	 */
	public static final String	ENTRIES_ADDED_KEY	= "EntriesAdded";
	
	/**
		Key corresponding to getEntriesRemoved()
	 */
	public static final String	ENTRIES_REMOVED_KEY	= "EntriesRemoved";
	
	/**
		Key corresponding to getEntriesDeleted()
	 */
	public static final String	ENTRIES_DELETED_KEY	= "EntriesDeleted";
	
		public
	DeploymentSourceImpl( final DeploymentSource src )
	{
		this( src.asMap() );
	}
	
		public <T extends Serializable>
	DeploymentSourceImpl( final Map<String, T> m )
	{
		super( m, DEPLOYMENT_SOURCE_CLASS_NAME);
		checkValidType( m, DEPLOYMENT_SOURCE_CLASS_NAME );
		
		validateThrow();
	}
	
		public <T extends Serializable>
	DeploymentSourceImpl(
		final String	archiveFile,
		final boolean	isCompleteArchive,
		final String[]	entriesAdded,
		final String[]	entriesRemoved,
		final String[]	entriesDeleted,
		final Map<String,T>		other )
	{
		super( other, DEPLOYMENT_SOURCE_CLASS_NAME);
		
		putField( ARCHIVE_FILE_KEY, archiveFile );
		putField( IS_COMPLETE_ARCHIVE_KEY, new Boolean( isCompleteArchive ) );
		putField( ENTRIES_ADDED_KEY, entriesAdded );
		putField( ENTRIES_REMOVED_KEY, entriesRemoved );
		putField( ENTRIES_DELETED_KEY, entriesDeleted );
		
		validateThrow();
	}
	
	
		protected boolean
	validate()
	{
		boolean valid	= validateNullOrOfType( ARCHIVE_FILE_KEY, String.class );
		
		if ( valid )
		{
			valid	= validateNullOrOfType( IS_COMPLETE_ARCHIVE_KEY, Boolean.class );
		}
		
		if ( valid )
		{
			valid	= validateNullOrOfType( ENTRIES_ADDED_KEY, String[].class ) &&
						validateNullOrOfType( ENTRIES_REMOVED_KEY, String[].class ) &&
						validateNullOrOfType( ENTRIES_DELETED_KEY, String[].class );
		}
		
		return( valid );
	}
	

		public String
	getMapClassName()
	{
		return( DEPLOYMENT_SOURCE_CLASS_NAME );
	}
	
		public File
    getArchive()
    {
    	return( getFile( ARCHIVE_FILE_KEY ) );
    }
       
    	public JarInputStream
    getArchiveAsStream()
    	throws IOException
    {
    	return( new JarInputStream( new FileInputStream( getArchive() ) ) );
    }
    
		public boolean
    isCompleteArchive()
    {
    	return( getboolean( IS_COMPLETE_ARCHIVE_KEY ) );
    }
    
    	public String[]
    getEntriesAdded()
    {
    	return( getStringArray( ENTRIES_ADDED_KEY ) );
    }
    
    	public String[]
    getEntriesRemoved()
    {
    	return( getStringArray( ENTRIES_REMOVED_KEY ) );
    }
    
		public String[]
	getEntriesDeleted()
	{
    	return( getStringArray( ENTRIES_DELETED_KEY ) );
	}
}








