/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.ext.logging;


/**
	Indices into log record fields as returned by
	{@link LogQuery#queryServerLog}.  Also 
	@since AppServer 9.0
 */
public final class LogRecordFields
{
	private LogRecordFields()	{}
	
	/** Value is of class java.lang.Integer */
    public final static int    RECORD_NUMBER_INDEX   = 0;
    
	/** Value is of class java.util.Date */
    public final static int    DATE_INDEX            = 1;
    
	/** Value is of class java.lang.String */
    public final static int    LEVEL_INDEX           = 2;
    
	/** Value is of class java.lang.String */
    public final static int    PRODUCT_NAME_INDEX    = 3;
    
	/** Value is of class java.lang.Integer */
    public final static int    MESSAGE_INDEX         = 4;
    
	/** Value is of class java.lang.String */
    public final static int    MESSAGE_ID_INDEX      = 5;
    
	/** Value is of class java.lang.String */
    public final static int    MODULE_INDEX          = 6;
    
	/** Value is of class java.lang.String */
    public final static int    NAME_VALUE_PAIRS_INDEX  = 7;
    
    /** Number of fields provided by {@link LogQuery#queryServerLog} */
    public final static int    NUM_FIELDS   = NAME_VALUE_PAIRS_INDEX + 1;
    
    public final static String THREAD_ID_KEY   = "_ThreadID";
    public final static String OBJECTNAME_KEY   = "_ObjectName";
}

