/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/Attic/EJBModule.java,v 1.4 2006/01/31 02:44:06 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/01/31 02:44:06 $
 */
 
package com.sun.appserv.management.j2ee;

import java.util.Set;

import com.sun.appserv.management.base.Container;

/**
 */
public interface EJBModule extends J2EEModule, Container
{
	public final static String	J2EE_TYPE	= J2EETypes.EJB_MODULE;
	
	/**
		Note that the Attribute name is case-sensitive
		"servlets" as defined by JSR 77.
		
		@return the ObjectNames of the ejbs, as Strings
	 */
	public String[]	getejbs();

	/**
		Return a Set of all EJBs.  Possible types include:
		<ul>
		<li>{@link EntityBean}</li>
		<li>{@link StatelessSessionBean}</li>
		<li>{@link StatefulSessionBean}</li>
		<li>{@link MessageDrivenBean}</li>
		</ul>
		<p>
		To get a Map of specific types of EJBs, use
		{@link Container#getContaineeMap}
	 */
	public <T extends EJB> Set<T>	getEJBSet();
}
