/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/Attic/J2EELogicalServer.java,v 1.4 2006/03/09 20:30:28 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:28 $
 */
package com.sun.appserv.management.j2ee;

import java.util.*;
import javax.management.ObjectName;


/**
	Base interface only (for cluster and standalone server)
 */
public interface J2EELogicalServer extends J2EEManagedObject, StateManageable
{
	/**
	 * Start the application on this Server.
	 *
	 * @param appID The application ID
	 * @param optional Optional parameters supplied as name-value pairs
	 * The parameters are documented here:
	 * {@link com.sun.appserv.management.deploy.DeploymentMgr#startDeploy}
	 */
	public void startApp(String appID, Map<String,String> optional);

	/**
	 * Stop the application on this Server.
	 *
	 * @param appID The application ID
	 * @param optional Optional parameters supplied as name-value pairs
	 * The parameters are documented here:
	 * {@link com.sun.appserv.management.deploy.DeploymentMgr#startDeploy}
	 */
	public void stopApp(String appID, Map<String,String> optional);
}

